/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.owo.util.EventStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatchedDataComponentMap.class})
public abstract class PatchedDataComponentMapMixin
implements PatchedDataComponentMapExtension {
    @Unique
    private boolean changeCheckStack = false;
    @Nullable
    private ItemStack itemStack = null;
    @Nullable
    private EventStream<ItemStackMutation> mutationEvent = null;
    @Unique
    private boolean inApplyPatchLock = false;

    @Override
    public EventStream<ItemStackMutation> accessories$getMutationEvent(ItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        this.itemStack = itemStack;
        if (this.mutationEvent == null) {
            this.mutationEvent = new EventStream(invokers -> (stack, types) -> invokers.forEach(itemStackMutation -> itemStackMutation.onMutation(stack, types)));
        }
        return this.mutationEvent;
    }

    @Override
    public boolean accessories$hasChanged() {
        boolean bl = this.changeCheckStack;
        this.changeCheckStack = false;
        return bl;
    }

    @Inject(method={"set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_set(DataComponentType<? super T> component, @Nullable T value, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @Inject(method={"remove(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_remove(DataComponentType<? super T> component, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatchHead(DataComponentPatch patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        this.inApplyPatchLock = true;
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="TAIL")})
    private void accessories$updateChangeValue_applyPatchTail(DataComponentPatch patch, CallbackInfo ci) {
        this.inApplyPatchLock = false;
        List<DataComponentType<?>> changedDataTypes = patch.entrySet().stream().map(Map.Entry::getKey).toList();
        this.accessories$handleMutationEvent(changedDataTypes);
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentType;Ljava/util/Optional;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatch(DataComponentType<?> component, Optional<?> value, CallbackInfo ci) {
        this.changeCheckStack = true;
        if (!this.inApplyPatchLock) {
            this.accessories$handleMutationEvent(List.of(component));
        }
    }

    @Inject(method={"restorePatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_restorePatch(DataComponentPatch patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        List<DataComponentType<?>> changedDataTypes = patch.entrySet().stream().map(Map.Entry::getKey).toList();
        this.accessories$handleMutationEvent(changedDataTypes);
    }

    @Unique
    private void accessories$handleMutationEvent(List<DataComponentType<?>> changedDataTypes) {
        if (this.mutationEvent == null) {
            return;
        }
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, changedDataTypes);
    }
}

