/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.client.gui.ScreenVariantSelectionScreen;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.shader.GlProgram;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Vector2i;

public class AccessoriesClient {
    public static KeyMapping OPEN_SCREEN = null;
    public static final ResourceLocation BLIT_SHADER_ID = Accessories.of("fish");
    public static ShaderInstance BLIT_SHADER;
    public static GlProgram SPECTRUM_PROGRAM;
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT;
    public static boolean IS_PLAYER_INVISIBLE;
    private static boolean displayUnusedSlotWarning;

    public static void initConfigStuff() {
        ConfigScreenProviders.register((String)"accessories", ExtendedConfigScreen.buildFunc(Accessories.config(), (config, factoryRegister) -> {
            factoryRegister.registerFactory(option -> {
                Field field = option.backingField().field();
                if (field.getType() != List.class) {
                    return false;
                }
                Class listType = ReflectionUtils.getTypeArgument((Type)field.getGenericType(), (int)0);
                if (listType == null) {
                    return false;
                }
                return String.class != listType && !NumberReflection.isNumberType((Class)listType);
            }, (uiModel, option) -> {
                StructListOptionContainer layout = new StructListOptionContainer(uiModel, option);
                return new OptionComponentFactory.Result(layout, layout);
            });
            ReflectiveEndecBuilder builder = ((ConfigWrapperAccessor)config).accessories$builder();
            factoryRegister.registerFactory(option -> option.backingField().field().isAnnotationPresent(Structured.class), (model, option) -> {
                Structured annotationData = option.backingField().field().getAnnotation(Structured.class);
                MutableComponent title = net.minecraft.network.chat.Component.translatable((String)("text.config." + option.configName() + ".option." + option.key().asString()));
                FlowLayout titleLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                titleLayout.padding(Insets.of((int)5, (int)5, (int)5, (int)0));
                title = title.copy().withStyle(ChatFormatting.UNDERLINE);
                titleLayout.child((Component)Components.label((net.minecraft.network.chat.Component)title));
                StructOptionContainer component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());
                titleLayout.child((Component)new SearchAnchorComponent((ParentComponent)titleLayout, option.key(), new Supplier[]{() -> I18n.get((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> component.parsedValue().toString()}));
                FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                mainLayout.child((Component)titleLayout).child((Component)component);
                return new OptionComponentFactory.Result((Component)mainLayout, (OptionValueProvider)component);
            });
        }));
        Accessories.config().clientOptions.subscribeToEquipControl(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.equipControl() == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, value));
        }));
        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.showUnusedSlots() == value.booleanValue()) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, value));
        }));
    }

    public static void init() {
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            AccessoriesRendererRegistry.onReload();
        });
        SPECTRUM_PROGRAM = new GlProgram(Accessories.of("spectrum_position_tex"), DefaultVertexFormat.POSITION_TEX_COLOR);
        AccessoriesClient.initLayer();
    }

    private static void attemptAction(Consumer<AccessoriesHolder> consumer) {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder != null) {
            consumer.accept(holder);
        }
    }

    public static void initalConfigDataSync() {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder == null) {
            return;
        }
        PlayerEquipControl equipControl = Accessories.config().clientOptions.equipControl();
        if (holder.equipControl() != equipControl) {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, equipControl));
        }
        boolean showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();
        if (holder.showUnusedSlots() != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, showUnusedSlots));
        }
    }

    public static boolean attemptToOpenScreen() {
        return AccessoriesClient.attemptToOpenScreen(false);
    }

    public static boolean attemptToOpenScreen(boolean targetingLookingEntity) {
        return AccessoriesClient.attemptToOpenScreen(targetingLookingEntity, Accessories.config().screenOptions.selectedScreenType());
    }

    private static boolean attemptToOpenScreen(boolean targetingLookingEntity, ScreenType screenType) {
        LocalPlayer player = Minecraft.getInstance().player;
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.getVariant(screenType);
        if (targetingLookingEntity) {
            LivingEntity living;
            EntityHitResult entityHitResult;
            Entity entity;
            boolean bl;
            HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> e instanceof LivingEntity, (double)player.entityInteractionRange());
            boolean bl2 = bl = !(result instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) || EntitySlotLoader.getEntitySlots(living = (LivingEntity)entity).isEmpty();
            if (bl) {
                return false;
            }
        } else {
            Collection<SlotType> slots = AccessoriesAPI.getUsedSlotsFor((Player)player);
            AccessoriesHolder holder = player.accessoriesHolder();
            if (holder == null) {
                return false;
            }
            if (slots.isEmpty() && !holder.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.displayClientMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
        }
        if (selectedVariant != null) {
            AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingLookingEntity, selectedVariant));
        } else {
            Minecraft.getInstance().setScreen((Screen)new ScreenVariantSelectionScreen(variant -> AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingLookingEntity, variant))));
        }
        return true;
    }

    public static void initLayer() {
        Layers.add(Containers::verticalFlow, instance -> {
            instance.aggressivePositioning = true;
            boolean creativeScreen = instance.screen instanceof CreativeModeInventoryScreen;
            ((FlowLayout)instance.adapter.rootComponent).allowOverflow(true);
            Vector2i offset = creativeScreen ? Accessories.config().screenOptions.creativeInventoryButtonOffset() : Accessories.config().screenOptions.inventoryButtonOffset();
            ButtonComponent button = (ButtonComponent)Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)""), btn -> AccessoriesClient.attemptToOpenScreen()).renderer((context, btn, delta) -> {
                context.push();
                context.blit(Accessories.of("textures/gui/accessories_open_icon" + (btn.isHovered() ? "_hovered" : "") + ".png"), btn.x(), btn.y(), 0.0f, 0.0f, 8, 8, 8, 8);
                context.pop();
            }).tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)Accessories.translationKey("open.screen"))).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)8));
            if (creativeScreen) {
                ComponentUtils.CreativeScreenExtension extension = (ComponentUtils.CreativeScreenExtension)instance.screen;
                button.visible = extension.getTab().getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                extension.getEvent().register(tab -> {
                    button.visible = tab.getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                });
            }
            ((FlowLayout)instance.adapter.rootComponent).child((Component)button);
            instance.alignComponentToHandledScreenCoordinates((Component)button, offset.x, offset.y);
        }, (Class[])new Class[]{InventoryScreen.class, CreativeModeInventoryScreen.class});
    }

    static {
        WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
            for (WindowResizeCallback callback : callbacks) {
                callback.onResized(client, window);
            }
        });
        IS_PLAYER_INVISIBLE = false;
        displayUnusedSlotWarning = false;
    }

    public static interface WindowResizeCallback {
        public void onResized(Minecraft var1, Window var2);
    }
}

