/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.client.rendering.ClientTransformationUtils;
import io.wispforest.accessories.api.client.rendering.ModelTransformUtils;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryRenderTransformations;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.compat.config.RenderSlotTarget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class DefaultAccessoryRenderer
implements AccessoryRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DefaultAccessoryRenderer INSTANCE;
    private final Map<String, RenderHelper> slotToHelpers = new HashMap<String, RenderHelper>();
    private static final Map<String, RenderHelper> DEFAULT_HELPERS;

    public DefaultAccessoryRenderer() {
        this.slotToHelpers.putAll(DEFAULT_HELPERS);
    }

    public static void registerHelper(String slotType, RenderHelper helper) {
        Map<String, RenderHelper> helpers = DefaultAccessoryRenderer.INSTANCE.slotToHelpers;
        if (!helpers.containsKey(slotType)) {
            helpers.put(slotType, helper);
        } else {
            LOGGER.warn("[DefaultAccessoryRenderer] Unable to add to the main renderer instance due to a duplicate helper already exists!");
        }
    }

    @Override
    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(model instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel humanoidModel = (HumanoidModel)model;
        List<RenderSlotTarget> disabledTargetType = Accessories.config().clientOptions.disabledDefaultRenders();
        for (RenderSlotTarget target : disabledTargetType) {
            if (!reference.slotName().equals(target.slotType) || !target.targetType.isValid(stack.getItem())) continue;
            return;
        }
        Consumer<PoseStack> render = poseStack -> Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, reference.entity().level(), 0);
        AccessoryRenderTransformations translationData = (AccessoryRenderTransformations)stack.getOrDefault(AccessoriesDataComponents.RENDER_TRANSFORMATIONS, (Object)AccessoryRenderTransformations.EMPTY);
        Consumer<PoseStack> translationAndRender = poseStack -> ClientTransformationUtils.transformStack(translationData.transformations(), poseStack, reference.entity(), (EntityModel<? extends LivingEntity>)humanoidModel, () -> render.accept((PoseStack)poseStack));
        if (!translationData.disableDefaultTranslations()) {
            RenderHelper helper = this.slotToHelpers.get(reference.slotName());
            if (helper != null) {
                helper.render(translationAndRender, matrices, humanoidModel, reference);
            }
        } else {
            translationAndRender.accept(matrices);
        }
    }

    @Override
    public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
        String slotName = reference.slotName();
        return (slotName.equals("hand") || slotName.equals("wrist") || slotName.equals("ring")) && (reference.slot() % 2 == 0 ? arm == HumanoidArm.RIGHT : arm == HumanoidArm.LEFT);
    }

    static {
        DEFAULT_HELPERS = Map.ofEntries(Map.entry("face", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "head", Side.FRONT);
                renderCall.accept(matrices);
            }
        }), Map.entry("hat", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "head", Side.TOP);
                matrices.translate(0.0, 0.25, 0.0);
                for (int i = 0; i < reference.getStack().getCount(); ++i) {
                    renderCall.accept(matrices);
                    matrices.translate(0.0, 0.5, 0.0);
                }
            }
        }), Map.entry("back", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "body", Side.BACK);
                matrices.scale(1.5f, 1.5f, 1.5f);
                renderCall.accept(matrices);
            }
        }), Map.entry("necklace", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, "body", 0, 1, 1);
                matrices.translate(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("cape", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, "body", 0, 1, -1);
                matrices.translate(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("ring", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                int xPercent = reference.slot() % 2 == 0 ? 1 : -1;
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, xPercent, -1, 0);
                int offset = reference.slot() / 2;
                matrices.translate((double)((reference.slot() % 2 == 0 ? -1 : 1) * offset) * -1.0E-4, 0.25 * (double)(offset + 1), 0.0);
                matrices.scale(0.5f, 0.5f, 0.5f);
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                for (int i = 0; i < reference.getStack().getCount(); ++i) {
                    renderCall.accept(matrices);
                    matrices.translate(0.0, 0.0, reference.slot() % 2 == 0 ? -0.5 : 0.5);
                }
            }
        }), Map.entry("wrist", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.scale(1.01f, 1.01f, 1.01f);
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("hand", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, modelTarget, Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("belt", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "body", Side.BOTTOM);
                matrices.scale(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("anklet", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_leg" : "left_leg";
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.scale(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("shoes", new RenderHelper(){

            @Override
            public <M extends LivingEntity> void render(Consumer<PoseStack> renderCall, PoseStack matrices, HumanoidModel<M> humanoidModel, SlotReference reference) {
                matrices.pushPose();
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "right_leg", Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.popPose();
                matrices.pushPose();
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "left_leg", Side.BOTTOM);
                matrices.translate(0.0, 0.25, 0.0);
                matrices.scale(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.popPose();
            }
        }));
        INSTANCE = new DefaultAccessoryRenderer();
    }

    public static interface RenderHelper {
        public <M extends LivingEntity> void render(Consumer<PoseStack> var1, PoseStack var2, HumanoidModel<M> var3, SlotReference var4);
    }
}

