/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.caching;

import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.world.item.ItemStack;

public class DataComponentMapPredicate
extends ItemStackBasedPredicate {
    public final DataComponentMap dataComponentMap;

    public DataComponentMapPredicate(String name, DataComponentMap dataComponentMap) {
        super(name);
        this.dataComponentMap = dataComponentMap;
    }

    @Override
    public boolean test(ItemStack stack) {
        for (TypedDataComponent typedDataComponent : this.dataComponentMap) {
            if (typedDataComponent.equals(stack.get(typedDataComponent.type()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.dataComponentMap.stream().toArray());
    }

    @Override
    protected boolean isEqual(Object other) {
        DataComponentMapPredicate dataComponentMapPredicate = (DataComponentMapPredicate)other;
        return Objects.equals(this.dataComponentMap, dataComponentMapPredicate.dataComponentMap);
    }

    @Override
    public String extraStringData() {
        return "DataComponents: " + this.dataComponentMap.toString();
    }

    public static interface ComponentAddCallback {
        public <T> void add(DataComponentType<T> var1, T var2);
    }
}

