/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.attributes.AttributeModificationData;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AccessoryAttributeBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>> exclusiveAttributes;
    private final Multimap<Holder<Attribute>, AttributeModificationData> stackedAttributes;
    private final SlotReference slotReference;
    private final Set<ResourceLocation> previouslyWarnedLocations = new HashSet<ResourceLocation>();

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotReference slotReference, @Nullable AccessoryAttributeBuilder parentBuilder) {
        this.slotReference = slotReference;
        if (parentBuilder != null) {
            this.exclusiveAttributes = parentBuilder.exclusiveAttributes;
            this.stackedAttributes = parentBuilder.stackedAttributes;
        } else {
            this.exclusiveAttributes = new HashMap<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>>();
            this.stackedAttributes = LinkedHashMultimap.create();
        }
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotReference slotReference) {
        this(slotReference, null);
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(String slotName, int slot) {
        this(SlotReference.of(null, slotName, slot));
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder() {
        this(SlotReference.of(null, "", 0));
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        this.addExclusive(attribute, new AttributeModifier(location, amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        this.addStackable(attribute, new AttributeModifier(location, amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addExclusive(Holder<Attribute> attribute, AttributeModifier modifier) {
        ResourceLocation id = modifier.id();
        Map innerMap = this.exclusiveAttributes.computeIfAbsent(attribute, attributeHolder -> new HashMap());
        if (AccessoriesLoaderInternals.isDevelopmentEnv() && innerMap.containsKey(id) && !this.previouslyWarnedLocations.contains(id)) {
            LOGGER.warn("A given Modifier was found to have a duplicate location but was added as exclusive, was such on purpose as such will not stack with the other: {}", (Object)id);
            this.previouslyWarnedLocations.add(id);
        }
        innerMap.putIfAbsent(id, new AttributeModificationData(attribute, modifier));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(Holder<Attribute> attribute, AttributeModifier modifier) {
        this.stackedAttributes.put(attribute, (Object)new AttributeModificationData(this.slotReference.createSlotPath(), attribute, modifier));
        return this;
    }

    @Nullable
    public AttributeModificationData getExclusive(Holder<Attribute> attribute, ResourceLocation location) {
        Map<ResourceLocation, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(location);
    }

    public Collection<AttributeModificationData> getStacks(Holder<Attribute> attribute, ResourceLocation location) {
        return this.stackedAttributes.get(attribute).stream().filter(data -> data.modifier().id().equals((Object)location)).toList();
    }

    @Nullable
    public AttributeModificationData removeExclusive(Holder<Attribute> attribute, ResourceLocation location) {
        Map<ResourceLocation, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.remove(location);
    }

    public Collection<AttributeModificationData> removeStacks(Holder<Attribute> attribute, ResourceLocation location) {
        HashSet<AttributeModificationData> removedData = new HashSet<AttributeModificationData>();
        for (AttributeModificationData data : List.copyOf(this.stackedAttributes.get(attribute))) {
            if (!data.modifier().id().equals((Object)location)) continue;
            removedData.add(data);
            this.stackedAttributes.remove(attribute, (Object)data);
        }
        return removedData;
    }

    public Multimap<String, AttributeModifier> getSlotModifiers() {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            Object patt0$temp = uniqueInstance.attribute().value();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)((Object)((Object)((Object)patt0$temp)));
            map.put((Object)slotAttribute.slotName(), (Object)uniqueInstance.modifier());
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            Object patt0$temp = stackedInstance.attribute().value();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)((Object)((Object)patt0$temp));
            map.put((Object)slotAttribute.slotName(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(boolean filterSlots) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            if (filterSlots && uniqueInstance.attribute().value() instanceof SlotAttribute) {
                return;
            }
            map.put(uniqueInstance.attribute(), (Object)uniqueInstance.modifier());
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            if (filterSlots && stackedInstance.attribute().value() instanceof SlotAttribute) {
                return;
            }
            map.put(stackedInstance.attribute(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public boolean isEmpty() {
        return this.exclusiveAttributes.isEmpty() && this.stackedAttributes.isEmpty();
    }

    public Map<Holder<Attribute>, Map<ResourceLocation, AttributeModificationData>> exclusiveAttributes() {
        return ImmutableMap.copyOf(this.exclusiveAttributes);
    }

    public Multimap<Holder<Attribute>, AttributeModificationData> stackedAttributes() {
        return ImmutableMultimap.copyOf(this.stackedAttributes);
    }

    public AccessoryAttributeBuilder addFrom(AccessoryAttributeBuilder builder) {
        builder.exclusiveAttributes.forEach(this.exclusiveAttributes::putIfAbsent);
        this.stackedAttributes.putAll(builder.stackedAttributes);
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessoryAttributeBuilder)) {
            return false;
        }
        AccessoryAttributeBuilder otherBuilder = (AccessoryAttributeBuilder)obj;
        if (!AccessoryAttributeBuilder.areMapsEqual(this.stackedAttributes, otherBuilder.stackedAttributes)) {
            return false;
        }
        return this.exclusiveAttributes.equals(otherBuilder.exclusiveAttributes);
    }

    private static <K, V> boolean areMapsEqual(Multimap<K, V> multimap1, Multimap<K, V> multimap2) {
        for (Map.Entry entry : multimap1.asMap().entrySet()) {
            if (!((Collection)entry.getValue()).equals(multimap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String createSlotPath(SlotReference ref) {
        return ref.createSlotPath();
    }

    @Deprecated
    public static String createSlotPath(String slotname, int slot) {
        return slotname.replace(":", "-") + "/" + slot;
    }
}

