/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.mixin.LivingEntityAccessor;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Accessory {
    default public void tick(ItemStack stack, SlotReference reference) {
    }

    default public void onEquip(ItemStack stack, SlotReference reference) {
    }

    default public void onUnequip(ItemStack stack, SlotReference reference) {
    }

    default public boolean canEquip(ItemStack stack, SlotReference reference) {
        return true;
    }

    default public boolean canUnequip(ItemStack stack, SlotReference reference) {
        if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            Player player;
            LivingEntity livingEntity = reference.entity();
            return livingEntity instanceof Player && (player = (Player)livingEntity).isCreative();
        }
        return true;
    }

    default public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        this.getModifiers(stack, reference, builder);
    }

    default public void getStaticModifiers(Item item, AccessoryItemAttributeModifiers.Builder builder) {
    }

    default public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        return DropRule.DEFAULT;
    }

    default public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        SoundEventData sound = this.getEquipSound(stack, reference);
        if (sound == null) {
            return;
        }
        reference.entity().playSound((SoundEvent)sound.event().value(), sound.volume(), sound.pitch());
    }

    @Nullable
    default public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        return new SoundEventData((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GENERIC, 1.0f, 1.0f);
    }

    default public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.canEquipFromUse(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Deprecated(forRemoval=true)
    default public boolean canEquipFromUse(ItemStack stack, SlotReference reference) {
        return true;
    }

    default public void onBreak(ItemStack stack, SlotReference reference) {
        ((LivingEntityAccessor)reference.entity()).accessors$breakItem(stack);
    }

    default public int maxStackSize(ItemStack stack) {
        return stack.getMaxStackSize();
    }

    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.getAttributesTooltip(stack, type, tooltips);
    }

    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        this.getExtraTooltip(stack, tooltips);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips) {
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public void getExtraTooltip(ItemStack stack, List<Component> tooltips) {
    }
}

