/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public record TreeFromStructureNBTConfigV2(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, List<BlockStateProvider> leavesProvider, Set<Block> logTarget, List<Block> leavesTarget, BlockPredicate growableOn, BlockPredicate leavesPlacementFilter, int maxLogDepth, List<TreeDecorator> treeDecorators, Map<Block, BlockStateProvider> replaceFromNBT, boolean isSapling, Orientation orientation) implements FeatureConfiguration
{
    public static final Codec<Set<Block>> BLOCK_SET_CODEC = Codec.list((Codec)BuiltInRegistries.BLOCK.byNameCodec()).xmap(ObjectOpenHashSet::new, ArrayList::new);
    public static final Codec<TreeFromStructureNBTConfigV2> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("base_location").forGetter(TreeFromStructureNBTConfigV2::baseLocation), (App)ResourceLocation.CODEC.fieldOf("canopy_location").forGetter(TreeFromStructureNBTConfigV2::canopyLocation), (App)IntProvider.CODEC.fieldOf("height").forGetter(TreeFromStructureNBTConfigV2::height), (App)BlockStateProvider.CODEC.fieldOf("log_provider").forGetter(TreeFromStructureNBTConfigV2::logProvider), (App)BlockStateProvider.CODEC.listOf().fieldOf("leaves_provider").forGetter(TreeFromStructureNBTConfigV2::leavesProvider), (App)BLOCK_SET_CODEC.fieldOf("log_target").forGetter(TreeFromStructureNBTConfigV2::logTarget), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("leaves_target").forGetter(TreeFromStructureNBTConfigV2::leavesTarget), (App)BlockPredicate.CODEC.fieldOf("can_grow_on_filter").forGetter(TreeFromStructureNBTConfigV2::growableOn), (App)BlockPredicate.CODEC.fieldOf("can_leaves_place_filter").forGetter(TreeFromStructureNBTConfigV2::leavesPlacementFilter), (App)Codec.INT.optionalFieldOf("max_log_depth", (Object)5).forGetter(TreeFromStructureNBTConfigV2::maxLogDepth), (App)TreeDecorator.CODEC.listOf().optionalFieldOf("decorators", new ArrayList()).forGetter(TreeFromStructureNBTConfigV2::treeDecorators), (App)Codec.unboundedMap((Codec)BuiltInRegistries.BLOCK.byNameCodec(), (Codec)BlockStateProvider.CODEC).fieldOf("replace_from_nbt").forGetter(TreeFromStructureNBTConfigV2::replaceFromNBT), (App)Codec.BOOL.optionalFieldOf("sapling", (Object)false).forGetter(TreeFromStructureNBTConfigV2::isSapling), (App)Orientation.CODEC.optionalFieldOf("orientation", (Object)Orientation.STANDARD).forGetter(TreeFromStructureNBTConfigV2::orientation)).apply((Applicative)builder, TreeFromStructureNBTConfigV2::new));

    public static enum Orientation {
        STANDARD,
        UPSIDE_DOWN,
        SIDEWAYS;

        public static final Codec<Orientation> CODEC;

        static {
            CODEC = Codec.STRING.xmap(s -> Orientation.valueOf(s.toUpperCase()), s -> s.name().toUpperCase());
        }
    }

    public static class Builder {
        @Nullable
        private ResourceLocation baseLocation;
        @Nullable
        private ResourceLocation canopyLocation;
        @Nullable
        private IntProvider height;
        @Nullable
        private BlockStateProvider logProvider;
        @Nullable
        private List<BlockStateProvider> leavesProvider;
        @Nullable
        private Set<Block> logTarget;
        @Nullable
        private List<Block> leavesTarget;
        private BlockPredicate growableOn = BlockPredicate.replaceable();
        private BlockPredicate leavesPlacementFilter = BlockPredicate.replaceable();
        private int maxLogDepth = 5;
        private List<TreeDecorator> treeDecorators = new ArrayList<TreeDecorator>();
        private Map<Block, BlockStateProvider> replaceFromNBT = new HashMap<Block, BlockStateProvider>();
        private boolean isSapling = false;
        private Orientation orientation = Orientation.STANDARD;

        public Builder baseLocation(ResourceLocation baseLocation) {
            this.baseLocation = baseLocation;
            return this;
        }

        public Builder canopyLocation(ResourceLocation canopyLocation) {
            this.canopyLocation = canopyLocation;
            return this;
        }

        public Builder height(IntProvider height) {
            this.height = height;
            return this;
        }

        public Builder logProvider(BlockStateProvider logProvider) {
            this.logProvider = logProvider;
            return this;
        }

        public Builder leavesProvider(List<BlockStateProvider> leavesProvider) {
            this.leavesProvider = leavesProvider;
            return this;
        }

        public Builder logTarget(Set<Block> logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public Builder leavesTarget(List<Block> leavesTarget) {
            this.leavesTarget = leavesTarget;
            return this;
        }

        public Builder growableOn(BlockPredicate growableOn) {
            this.growableOn = growableOn;
            return this;
        }

        public Builder leavesPlacementFilter(BlockPredicate leavesPlacementFilter) {
            this.leavesPlacementFilter = leavesPlacementFilter;
            return this;
        }

        public Builder maxLogDepth(int maxLogDepth) {
            this.maxLogDepth = maxLogDepth;
            return this;
        }

        public Builder treeDecorators(List<TreeDecorator> treeDecorators) {
            this.treeDecorators = treeDecorators;
            return this;
        }

        public Builder replaceFromNBT(Map<Block, BlockStateProvider> placeFromNBT) {
            this.replaceFromNBT = placeFromNBT;
            return this;
        }

        public Builder isSapling(boolean isSapling) {
            this.isSapling = isSapling;
            return this;
        }

        public Builder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        public TreeFromStructureNBTConfigV2 build() {
            if (this.baseLocation == null) {
                throw new IllegalStateException("Base location cannot be null");
            }
            if (this.canopyLocation == null) {
                throw new IllegalStateException("Canopy location cannot be null");
            }
            if (this.height == null) {
                throw new IllegalStateException("Height cannot be null");
            }
            if (this.logProvider == null) {
                throw new IllegalStateException("Log provider cannot be null");
            }
            if (this.leavesProvider == null) {
                throw new IllegalStateException("Leaves provider cannot be null");
            }
            if (this.logTarget == null) {
                throw new IllegalStateException("Log target cannot be null");
            }
            if (this.leavesTarget == null) {
                throw new IllegalStateException("Leaves target cannot be null");
            }
            return new TreeFromStructureNBTConfigV2(this.baseLocation, this.canopyLocation, this.height, this.logProvider, this.leavesProvider, this.logTarget, this.leavesTarget, this.growableOn, this.leavesPlacementFilter, this.maxLogDepth, this.treeDecorators, this.replaceFromNBT, this.isSapling, this.orientation);
        }
    }
}

