/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.data.worldgen.features;

import dev.corgitaco.ohthetreesyoullgrow.Constants;
import dev.corgitaco.ohthetreesyoullgrow.data.worldgen.features.TYGConfiguredFeatures;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class TYGPlacedFeatures {
    public static final Map<ResourceKey<PlacedFeature>, PlacedFeatureFactory> PLACED_FEATURE_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<PlacedFeature> V1_TEST_TREE1 = TYGPlacedFeatures.createPlacedFeature("v1_test_tree1", TYGConfiguredFeatures.V1_TEST_TREE1, new Supplier[]{() -> CountPlacement.of((int)1)});
    public static final ResourceKey<PlacedFeature> V1_TEST_TREE2 = TYGPlacedFeatures.createPlacedFeature("v1_test_tree2", TYGConfiguredFeatures.V1_TEST_TREE2, new Supplier[]{() -> CountPlacement.of((int)1)});
    public static final ResourceKey<PlacedFeature> V1_TEST_TREE3 = TYGPlacedFeatures.createPlacedFeature("v1_test_tree3", TYGConfiguredFeatures.V1_TEST_TREE3, new Supplier[]{() -> CountPlacement.of((int)1)});
    public static final ResourceKey<PlacedFeature> V1_TEST_MUSHROOM1 = TYGPlacedFeatures.createPlacedFeature("v1_test_mushroom1", TYGConfiguredFeatures.V1_TEST_MUSHROOM1, new Supplier[]{() -> CountPlacement.of((int)1)});
    public static final ResourceKey<PlacedFeature> V1_TEST_MUSHROOM2 = TYGPlacedFeatures.createPlacedFeature("v1_test_mushroom2", TYGConfiguredFeatures.V1_TEST_MUSHROOM2, new Supplier[]{() -> CountPlacement.of((int)1)});

    @SafeVarargs
    private static ResourceKey<PlacedFeature> createPlacedFeature(String id, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<PlacementModifier> ... placementModifiers) {
        return TYGPlacedFeatures.createPlacedFeature(id, feature, () -> Arrays.stream(placementModifiers).map(Supplier::get).toList());
    }

    private static ResourceKey<PlacedFeature> createPlacedFeature(String id, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> placementModifiers) {
        ResourceLocation location = Constants.createLocation(id);
        ResourceKey placedFeatureKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)location);
        PLACED_FEATURE_FACTORIES.put((ResourceKey<PlacedFeature>)placedFeatureKey, configuredFeatureHolderGetter -> new PlacedFeature((Holder)configuredFeatureHolderGetter.getOrThrow(feature), (List)placementModifiers.get()));
        return placedFeatureKey;
    }

    public static void register() {
    }

    @FunctionalInterface
    public static interface PlacedFeatureFactory {
        public PlacedFeature generate(HolderGetter<ConfiguredFeature<?, ?>> var1);
    }
}

