/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.util;

import java.awt.Color;

public final class BorderColor {
    private static int colorCode;

    private BorderColor() {
    }

    public static void parseColor(String color) {
        try {
            colorCode = Integer.parseInt(color, 16);
        }
        catch (NumberFormatException e) {
            colorCode = -1;
        }
    }

    public static int getColor() {
        if (colorCode >= 0) {
            return colorCode;
        }
        float hue = (float)(System.currentTimeMillis() % 10000000L) / 1.0E7f * 360.0f;
        return 0xFFFFFF & Color.HSBtoRGB(hue, 1.0f, 1.0f);
    }

    public static float[] getRGB() {
        int color = BorderColor.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }
}

