/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.util.ClientBorder;
import org.popcraft.chunkyborder.util.PluginMessage;

public class BorderPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<BorderPayload> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"chunky:border"));
    private World world;
    private Shape shape;
    private ClientBorder border;

    public BorderPayload(World world, Shape shape) {
        this.world = world;
        this.shape = shape;
    }

    public BorderPayload(FriendlyByteBuf buf) {
        ByteBuf unwrapped = buf.unwrap();
        byte[] bytes = new byte[unwrapped.readableBytes()];
        unwrapped.readBytes(bytes);
        this.border = PluginMessage.readBorder(bytes);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBytes(PluginMessage.writeBorder(this.world, this.shape));
    }

    public ClientBorder getBorder() {
        return this.border;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<BorderPayload> type() {
        return ID;
    }
}

