/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.mixin;

import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.RelativeMovement;
import org.popcraft.chunky.ChunkyProvider;
import org.popcraft.chunky.platform.NeoForgePlayer;
import org.popcraft.chunky.platform.NeoForgeWorld;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunkyborder.event.server.PlayerTeleportEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class ServerGamePacketListenerImplMixin {
    @Shadow
    public ServerPlayer player;
    @Unique
    private Location redirect;

    @Inject(method={"teleport(DDDFFLjava/util/Set;)V"}, at={@At(value="HEAD")})
    private void requestTeleport(double x, double y, double z, float yaw, float pitch, Set<RelativeMovement> flags, CallbackInfo ci) {
        NeoForgePlayer neoForgePlayer = new NeoForgePlayer(this.player);
        NeoForgeWorld world = new NeoForgeWorld(this.player.serverLevel());
        Location location = new Location((World)world, x, y, z, yaw, pitch);
        PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent((Player)neoForgePlayer, location);
        ChunkyProvider.get().getEventBus().call((Object)playerTeleportEvent);
        Optional<Location> optionalLocation = playerTeleportEvent.redirect();
        optionalLocation.ifPresentOrElse(redirectLocation -> {
            this.redirect = redirectLocation;
        }, () -> {
            this.redirect = null;
        });
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), argsOnly=true, index=1)
    private double requestTeleportX(double x) {
        return this.redirect == null ? x : this.redirect.getX();
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), argsOnly=true, index=3)
    private double requestTeleportY(double y) {
        return this.redirect == null ? y : this.redirect.getY();
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), argsOnly=true, index=5)
    private double requestTeleportZ(double z) {
        return this.redirect == null ? z : this.redirect.getZ();
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), argsOnly=true, index=7)
    private float requestTeleportYaw(float yaw) {
        return this.redirect == null ? yaw : this.redirect.getYaw();
    }

    @ModifyVariable(method={"teleport(DDDFFLjava/util/Set;)V"}, at=@At(value="HEAD"), argsOnly=true, index=8)
    private float requestTeleportPitch(float pitch) {
        return this.redirect == null ? pitch : this.redirect.getPitch();
    }
}

