/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ClientConfig
implements ConfigCore {
    static final String KEY_ITEMS_CATEGORY = "items";
    static final String KEY_WIDGETS_CATEGORY = "widgets";
    @Config(name="description", category={"items"}, description={"Add effect description to item tooltips."})
    public boolean itemDescription = true;
    @Config(name="supported_items", category={"items"}, description={"Items that should support descriptions for the effects on their inventory tooltip.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> supportedItemsRaw = KeyedValueProvider.toString((ResourceKey)Registries.ITEM, (Object[])new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.TIPPED_ARROW, Items.SUSPICIOUS_STEW});
    @Config(category={"items"}, description={"Add effects to food tooltips."})
    public boolean foodEffects = true;
    @Config(description={"Amount of spaces to add at the beginning of an effect description."})
    @Config.IntRange(min=0, max=24)
    public int descriptionIndentation = 0;
    @Config(category={"items"}, description={"Only reveal effect description for items while any shift key is held."})
    public boolean shiftToReveal = false;
    @Config(name="description", category={"widgets"}, description={"Add effect description to effect widget tooltips in the survival and creative inventory screens."})
    public boolean widgetDescription = true;
    @Config(category={"widgets"}, description={"Add the effect name and duration to large effect widget tooltips, even though the widget already contains both."})
    public EffectNameMode nameAndDuration = EffectNameMode.NAME_AND_DURATION;
    @Config(category={"widgets"}, description={"Add attributes granted by an effect to effect widget tooltips."})
    public boolean attributes = true;
    @Config(category={"widgets"}, description={"Add the internal id of an effect to effect widget tooltips."})
    public boolean internalId = false;
    @Config(category={"widgets"}, description={"Add the name of the mod that added an effect to effect widget tooltips."})
    public boolean modName = false;
    public ConfigDataSet<Item> supportedItems;

    public void afterConfigReload() {
        this.supportedItems = ConfigDataSet.from((ResourceKey)Registries.ITEM, this.supportedItemsRaw, (Class[])new Class[0]);
    }

    public static enum EffectNameMode {
        NAME_ONLY,
        NAME_AND_DURATION,
        NONE;

    }
}

