/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeHelper {
    public static Biome getBiomeFromResource(ResourceLocation biome) {
        Minecraft mc = Minecraft.getInstance();
        return (Biome)mc.level.registryAccess().registryOrThrow(Registries.BIOME).get(biome);
    }

    public static Biome getBiomeFromResourceString(String biome) {
        ResourceLocation biomeResource = ResourceLocation.parse((String)biome);
        return BiomeHelper.getBiomeFromResource(biomeResource);
    }

    public static String getTranslatedBiomeName(Biome biome) {
        ResourceLocation biomeResource = BiomeHelper.getBiomeResource(biome);
        return BiomeHelper.getTranslatedBiomeName(biomeResource);
    }

    public static ResourceLocation getBiomeResource(Biome biome) {
        Minecraft mc = Minecraft.getInstance();
        return mc.level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
    }

    public static String getTranslatedBiomeName(ResourceLocation biomeResource) {
        String biomeName = Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)biomeResource)).getString();
        if (biomeName.contains("unregistered_sadface") || biomeName.startsWith("biome.")) {
            biomeName = biomeResource.getPath();
        }
        return biomeName;
    }
}

