/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class WaypointPanel<T extends WaypointSlot>
extends ScrollListLayoutPane<T> {
    WaypointSlot draggingSlot = null;

    public WaypointPanel(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int getRowLeft() {
        return super.getRowLeft();
    }

    @Override
    public void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            WaypointSlot slot = (WaypointSlot)this.getEntry(index);
            super.renderItem(graphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (slot.isDragging()) {
                this.draggingSlot = slot;
            }
            if (this.draggingSlot != null && (this.getRowBottom(index + 1) > this.getBottom() || index + 1 >= this.children().size())) {
                graphics.disableScissor();
                if (this.draggingSlot.isSelected()) {
                    graphics.pose().pushPose();
                    List<WaypointSlot> slots = this.getRootSlots().stream().filter(WaypointSlot::isSelected).toList();
                    int boxWidth = this.draggingSlot.name.getWidth() + this.draggingSlot.icon.getWidth() + 20;
                    int boxHeight = height * slots.size();
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, boxWidth, boxHeight, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, boxWidth, boxHeight + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.alpha * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                    int slotIndex = 1;
                    for (WaypointSlot renderSlot : slots) {
                        if (renderSlot == this.draggingSlot) continue;
                        renderSlot.renderGhost(graphics, mouseX, mouseY + height * slotIndex++, partialTick);
                    }
                    float texScale = 0.2f;
                    int posX = mouseX + (boxWidth >> 1);
                    int posY = mouseY + (boxHeight >> 1);
                    DynamicTexture texture = TextureCache.getTexture(TextureCache.MobIconBG);
                    float scaleX = (float)posX - (float)texture.getPixels().getWidth() * texScale / 2.0f;
                    float scaleY = (float)posY - (float)texture.getPixels().getHeight() * texScale / 2.0f;
                    graphics.pose().translate(0.0f, 0.0f, 10.0f);
                    DrawUtil.drawColoredImage(graphics, TextureCache.getTexture(TextureCache.MobIconBG), 0xFF0000, 0.4f, scaleX, scaleY, texScale, 0.0);
                    DrawUtil.drawCenteredLabel(graphics, Integer.toString(slots.size()), posX, posY, null, 0.0f, 0xFFFFFF, 0.8f, 2.0, false);
                    graphics.pose().popPose();
                } else {
                    int slotWidth = this.draggingSlot.name.getWidth() + this.draggingSlot.icon.getWidth() + 20;
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, slotWidth, height, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, slotWidth, height + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.alpha * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                }
                this.enableScissor(graphics);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error rendering waypoint slot item:", t);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingSlot = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.isMouseOver(mouseX, mouseY)) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(mouseX, mouseY, button)));
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public List<WaypointSlot> getDraggingSlots() {
        if (this.draggingSlot != null) {
            if (this.draggingSlot.isSelected()) {
                return this.getRootSlots().stream().filter(WaypointSlot::isSelected).collect(Collectors.toList());
            }
            return Lists.newArrayList((Object[])new WaypointSlot[]{this.draggingSlot});
        }
        return null;
    }

    @Override
    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> {
            if (slot != null && slot.getLayout() != null) {
                slot.getLayout().visitWidgets(consumer);
            }
        });
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(WaypointSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(WaypointSlot::repositionElements);
    }
}

