/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DeleteConfirmWaypointPopup
extends PopupButtonScreen<Boolean> {
    private boolean showConfirmation = true;

    protected DeleteConfirmWaypointPopup(Waypoint waypoint) {
        super((Component)Component.translatable((String)"jm.waypoint.delete.confirm.title", (Object[])new Object[]{waypoint.getName()}));
    }

    protected void init() {
        CheckBox checkbox = new CheckBox(Constants.getString("jm.waypoint.delete_waypoint.confirm.checkbox"), true, button -> this.disableConfirmation(((CheckBox)button).getToggled()));
        checkbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete_waypoint.confirm.checkbox.tooltip", (Object[])new Object[]{WaypointGroupStore.DEFAULT.getName()})));
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        this.layout.addChild((LayoutElement)checkbox);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(6);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.delete"), b -> this.delete()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void disableConfirmation(Boolean toggled) {
        this.showConfirmation = false;
    }

    private void delete() {
        if (!this.showConfirmation) {
            JourneymapClient.getInstance().getWaypointProperties().showDeleteConfirmation.set(false);
        }
        this.setResponseAndClose(true);
    }

    @Override
    public void setOnClosed(PopupButtonScreen.OnClose<Boolean> onClose) {
        this.onClose = onClose;
    }

    @Override
    protected void onClosed() {
        this.onClose.closed((Boolean)this.response);
        super.onClose();
    }
}

