/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import com.mojang.blaze3d.vertex.VertexConsumer;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class ImageDropDownItem
extends DropDownItem {
    private final int textureWidth;
    private final int textureHeight;
    private boolean blur = false;
    private DynamicTexture texture;
    private int color = -1;

    public ImageDropDownItem(SelectableParent parent, Object id, DynamicTexture texture, int textureWidth, int textureHeight, Button.OnPress onPress, String ... toolTip) {
        super(parent, id, true, "", onPress);
        this.setTooltip(toolTip);
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
        this.texture = texture;
        this.setWidth(textureWidth);
        this.setHeight(textureHeight);
    }

    public ImageDropDownItem setBlur() {
        this.blur = true;
        return this;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderImage(graphics, this.getX() + (this.width >> 1) - (this.textureWidth >> 1), this.getY());
    }

    public void renderImage(GuiGraphics graphics, int x, int y) {
        RenderType renderType = JMRenderTypes.getIconNoBlur((AbstractTexture)this.texture);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics, vertexBuilder, this.color, 1.0f, (double)x, (double)y, (double)this.textureWidth, (double)this.textureHeight, 0.0, false);
    }

    public void setColor(int color) {
        this.color = color;
    }
}

