/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.JMLogger;
import journeymap.client.model.region.RegionImageCache;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.HttpTextureAccess;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.ui.theme.Theme;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class TextureCache {
    public static final WidgetSprites TELEPORT_SPRITE = new WidgetSprites(TextureCache.uiImage("teleport.png"), TextureCache.uiImage("teleport.png"));
    public static final WidgetSprites SHARE_SPRITE = new WidgetSprites(TextureCache.uiImage("share.png"), TextureCache.uiImage("share.png"));
    public static final WidgetSprites POWER_SPRITE = new WidgetSprites(TextureCache.uiImage("power.png"), TextureCache.uiImage("power.png"));
    public static final WidgetSprites PIN_SPRITE = new WidgetSprites(TextureCache.uiImage("pin.png"), TextureCache.uiImage("pin.png"));
    public static final WidgetSprites OPTIONS_SPRITE = new WidgetSprites(TextureCache.uiImage("option.png"), TextureCache.uiImage("option.png"));
    public static final WidgetSprites X_OUTLINE_SPRITE = new WidgetSprites(TextureCache.uiImage("x_outline_icon.png"), TextureCache.uiImage("x_outline_icon.png"));
    public static final WidgetSprites X_SPRITE = new WidgetSprites(TextureCache.uiImage("x_icon.png"), TextureCache.uiImage("x_icon.png"));
    public static final ResourceLocation TOGGLE_ON = TextureCache.uiImage("toggle-button-on.png");
    public static final ResourceLocation TOGGLE_OFF = TextureCache.uiImage("toggle-button-off.png");
    public static final ResourceLocation ARROW_GLYPH = TextureCache.uiImage("arrow_glyph.png");
    public static final ResourceLocation Question = TextureCache.uiImage("question.png");
    public static final ResourceLocation GridSquares = TextureCache.uiImage("grid.png");
    public static final ResourceLocation GridRegionSquares = TextureCache.uiImage("grid-region.png");
    public static final ResourceLocation GridRegion = TextureCache.uiImage("region.png");
    public static final ResourceLocation SearchIcon = TextureCache.uiImage("search.png");
    public static final ResourceLocation ColorPicker = TextureCache.uiImage("colorpick.png");
    public static final ResourceLocation ColorPicker2 = TextureCache.uiImage("colorpick2.png");
    public static final ResourceLocation TileSampleDay = TextureCache.uiImage("tile-sample-day.png");
    public static final ResourceLocation TileSampleNight = TextureCache.uiImage("tile-sample-night.png");
    public static final ResourceLocation TileSampleUnderground = TextureCache.uiImage("tile-sample-underground.png");
    public static final ResourceLocation UnknownEntity = TextureCache.uiImage("unknown.png");
    public static final ResourceLocation Deathpoint = TextureCache.waypointTexture("waypoint-death-icon.png");
    public static final ResourceLocation Waypoint = TextureCache.waypointTexture("waypoint-icon.png");
    public static final ResourceLocation MobDot = TextureCache.uiImage("marker-dot-160.png");
    public static final ResourceLocation MobDotArrow = TextureCache.uiImage("marker-dot-arrow-160.png");
    public static final ResourceLocation MobDotChevron = TextureCache.uiImage("marker-chevron-160.png");
    public static final ResourceLocation MobIconArrow = TextureCache.uiImage("marker-icon-arrow-160.png");
    public static final ResourceLocation MobIconArrowBG = TextureCache.uiImage("marker-icon-arrow-bg-160.png");
    public static final ResourceLocation MobIcon = TextureCache.uiImage("marker-icon-160.png");
    public static final ResourceLocation MobIconBG = TextureCache.uiImage("marker-icon-bg-160.png");
    public static final ResourceLocation MobIconMask = TextureCache.uiImage("marker-icon-mask.png");
    public static final ResourceLocation PlayerArrow = TextureCache.uiImage("marker-player-160.png");
    public static final ResourceLocation PlayerArrowBG = TextureCache.uiImage("marker-player-bg-160.png");
    public static final ResourceLocation PlayerOutline = TextureCache.uiImage("marker-player-outline.png");
    public static final ResourceLocation Logo = TextureCache.uiImage("ico/journeymap.png");
    public static final ResourceLocation MinimapSquare128 = TextureCache.uiImage("minimap/minimap-square-128.png");
    public static final ResourceLocation MinimapSquare256 = TextureCache.uiImage("minimap/minimap-square-256.png");
    public static final ResourceLocation MinimapSquare512 = TextureCache.uiImage("minimap/minimap-square-512.png");
    public static final ResourceLocation Discord = TextureCache.uiImage("discord.png");
    public static final ResourceLocation CurseForge = TextureCache.uiImage("curseforge.png");
    public static final ResourceLocation Modrinth = TextureCache.uiImage("modrinth.png");
    public static final ResourceLocation ColorWheel = TextureCache.uiImage("colorwheel.png");
    public static final ResourceLocation ColorWheelHandler = TextureCache.uiImage("colorwheel-handler.png");
    public static final ResourceLocation ColorBox = TextureCache.uiImage("color-box.png");
    public static final ResourceLocation ColorVSlider = TextureCache.uiImage("color-v-slider.png");
    public static final ResourceLocation ColorVSliderHandler = TextureCache.uiImage("color-v-slider-handler.png");
    public static final ResourceLocation ColorHistoryButton = TextureCache.uiImage("color-history-button.png");
    public static final ResourceLocation Flag = TextureCache.uiImage("flag.png");
    public static final ResourceLocation WaypointEdit = TextureCache.uiImage("waypoint-edit.png");
    public static final ResourceLocation WaypointOffscreen = TextureCache.uiImage("waypoint-offscreen.png");
    private static final Map<String, ResourceLocation> dynamicTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, DynamicTexture> colorizedWPIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<ResourceLocation, DynamicTexture> waypointIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<ResourceLocation, ResourceLocation> modTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, DynamicTexture> playerSkins = Collections.synchronizedMap(new HashMap());
    public static final Map<String, DynamicTexture> themeImages = Collections.synchronizedMap(new HashMap());
    private static ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final Map<String, ResourceLocation> waypointIconCache = Collections.synchronizedMap(new HashMap<String, ResourceLocation>(){
        {
            this.put(Waypoint.toString(), Waypoint);
            this.put(Deathpoint.toString(), Deathpoint);
        }
    });

    public static ResourceLocation getTexture(String texturePath) {
        ResourceLocation tex = dynamicTextureMap.get(texturePath);
        if (tex == null) {
            tex = TextureCache.uiImage(texturePath);
            dynamicTextureMap.put(texturePath, tex);
        }
        return tex;
    }

    public static ResourceLocation spriteImage(String fileName) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)("ui/img/" + fileName));
        return location;
    }

    public static ResourceLocation waypointTexture(String fileName) {
        return ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)("textures/waypoint/icon/" + fileName));
    }

    public static ResourceLocation uiImage(String fileName) {
        return ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)("ui/img/" + fileName));
    }

    public static void flush() {
        LogUtils.getLogger().info("[JourneyMap]: Purging Theme Images");
        TextureCache.purgeThemeImages(themeImages);
        LogUtils.getLogger().info("[JourneyMap]: Purging Region Images");
        RegionImageCache.INSTANCE.flushToDisk(true);
        RegionImageCache.INSTANCE.clear();
        LogUtils.getLogger().info("[JourneyMap]: Purging Mob Icon Images");
        MobIconCache.clearCache();
    }

    public static DynamicTexture getTexture(ResourceLocation location) {
        AbstractTexture textureObject;
        block14: {
            NativeImage image;
            TextureManager textureManager;
            block13: {
                HttpTexture httpTexture;
                ResourceLocation loc;
                if (location == null) {
                    return null;
                }
                if (!location.getNamespace().equals("journeymap") && (loc = modTextureMap.get(location)) != null) {
                    location = loc;
                }
                if ((textureObject = (textureManager = Minecraft.getInstance().getTextureManager()).getTexture(location, null)) != null && textureObject instanceof HttpTexture) {
                    httpTexture = (HttpTexture)textureObject;
                    HttpTextureAccess tex = (HttpTextureAccess)httpTexture;
                    NativeImage img = tex.journeymap$getNativeImage();
                    if (img != null && img.pixels != 0L) {
                        textureObject = new DynamicTexture(tex.journeymap$getNativeImage());
                        textureManager.register(location, textureObject);
                    } else {
                        return null;
                    }
                }
                if (textureObject == null) break block13;
                if (!(textureObject instanceof SimpleTexture)) break block14;
                httpTexture = (SimpleTexture)textureObject;
            }
            if ((image = TextureCache.resolveImage(location)) != null) {
                textureObject = new DynamicTexture(image);
                if (!location.getNamespace().equals("journeymap")) {
                    ResourceLocation fakeLocation = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)location.getPath());
                    modTextureMap.put(location, fakeLocation);
                    textureManager.register(fakeLocation, textureObject);
                } else {
                    textureManager.register(location, textureObject);
                }
            }
        }
        try {
            return (DynamicTexture)textureObject;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Not a proper texture for {}", (Object)location);
            return null;
        }
    }

    public static DynamicTexture getWaypointIcon(ResourceLocation location) {
        if (!"journeymap".equals(location.getNamespace())) {
            TextureManager manager = Minecraft.getInstance().getTextureManager();
            ResourceLocation fakeResource = modTextureMap.get(location);
            if (fakeResource == null || manager.getTexture(fakeResource, null) == null) {
                fakeResource = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)location.getPath());
                modTextureMap.put(location, fakeResource);
                try (NativeImage nativeImage = TextureCache.resolveImage(location);){
                    NativeImage img = ImageUtil.getScaledImage(4.0f, nativeImage, false);
                    DynamicTexture scaledTexture = new DynamicTexture(img);
                    manager.register(fakeResource, (AbstractTexture)scaledTexture);
                    ((TextureAccess)scaledTexture).journeymap$setDisplayHeight(nativeImage.getHeight());
                    ((TextureAccess)scaledTexture).journeymap$setDisplayWidth(nativeImage.getHeight());
                }
            }
            return (DynamicTexture)manager.getTexture(fakeResource, null);
        }
        return TextureCache.getTexture(location);
    }

    public static <T extends AbstractTexture> Future<T> scheduleTextureTask(Callable<T> textureTask) {
        return texExec.submit(textureTask);
    }

    public static void reset() {
        playerSkins.clear();
        colorizedWPIconMap.clear();
        dynamicTextureMap.clear();
        modTextureMap.clear();
        waypointIconMap.clear();
        TextureCache.getTextures("waypoint/icon").forEach(loc -> waypointIconMap.put((ResourceLocation)loc, TextureCache.getTexture(loc)));
        Arrays.asList(OPTIONS_SPRITE, X_SPRITE, X_OUTLINE_SPRITE, TELEPORT_SPRITE, SHARE_SPRITE, POWER_SPRITE, PIN_SPRITE).forEach(TextureCache::resetSprite);
        Arrays.asList(ARROW_GLYPH, Question, ColorPicker, ColorPicker2, Deathpoint, GridSquares, GridRegionSquares, GridRegion, Logo, MinimapSquare128, MinimapSquare256, MinimapSquare512, MobDot, MobDotArrow, MobDotChevron, PlayerArrow, PlayerArrowBG, PlayerArrowBG, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity, SearchIcon, Waypoint, WaypointEdit, WaypointOffscreen, ColorPicker, ColorPicker2, GridSquares, GridRegion, GridRegionSquares, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity).stream().map(TextureCache::getTexture);
    }

    public static Collection<ResourceLocation> getTextures(String path) {
        Map textures = Minecraft.getInstance().getResourceManager().listResources("textures/" + path, location -> location.getPath().endsWith(".png"));
        return textures.keySet();
    }

    static void resetSprite(WidgetSprites sprites) {
        TextureCache.getTexture(sprites.disabled());
        TextureCache.getTexture(sprites.disabledFocused());
        TextureCache.getTexture(sprites.enabled());
        TextureCache.getTexture(sprites.enabledFocused());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeThemeImages(Map<String, DynamicTexture> themeImages) {
        Map<String, DynamicTexture> map = themeImages;
        synchronized (map) {
            themeImages.values().forEach(DynamicTexture::close);
            themeImages.clear();
        }
    }

    public static NativeImage resolveImage(ResourceLocation location) {
        if (location.getNamespace().equals("fake")) {
            return null;
        }
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        try {
            Resource resource = resourceManager.getResource(location).orElse(null);
            if (resource != null) {
                InputStream is = resource.open();
                return NativeImage.read((InputStream)is);
            }
            JMLogger.logOnce("Image is null: " + String.valueOf(location));
        }
        catch (FileNotFoundException | NullPointerException e) {
            try {
                Resource imgFile;
                if ("journeymap".equals(location.getNamespace()) && (imgFile = (Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.parse((String)("../src/main/resources/assets/journeymap/" + location.getPath()))).orElse(null)) != null) {
                    return NativeImage.read((InputStream)imgFile.open());
                }
            }
            catch (IOException ioe) {
                Journeymap.getLogger().warn("Image not found: " + ioe.getMessage());
            }
        }
        catch (Exception e) {
            JMLogger.throwLogOnce("Resource not readable: " + String.valueOf(location), e);
        }
        return null;
    }

    public static DynamicTexture getThemeTexture(Theme theme, String iconPath) {
        return TextureCache.getSizedThemeTexture(theme, iconPath, 0, 0, false, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicTexture getThemeTextureFromResource(ResourceLocation icon) {
        Map<String, DynamicTexture> map = themeImages;
        synchronized (map) {
            DynamicTexture tex = themeImages.get(icon.toString());
            if (tex == null || !((TextureAccess)tex).journeymap$hasImage()) {
                NativeImage nativeImage;
                if (tex != null) {
                    ImageUtil.closeSafely(tex);
                }
                if ((nativeImage = TextureCache.resolveImage(icon)) != null && nativeImage.pixels > 0L) {
                    tex = new DynamicTexture(nativeImage);
                    themeImages.put(icon.toString(), tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: {}", (Object)icon);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicTexture getSizedThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, DynamicTexture> map = themeImages;
        synchronized (map) {
            DynamicTexture tex = themeImages.get(texName);
            if (tex == null || !((TextureAccess)tex).journeymap$hasImage() || resize && (width != ((TextureAccess)tex).journeymap$getWidth() || height != ((TextureAccess)tex).journeymap$getHeight())) {
                File parentDir;
                NativeImage nativeImage;
                if (tex != null) {
                    ImageUtil.closeSafely(tex);
                }
                if ((nativeImage = FileHandler.getIconFromFile(parentDir = ThemeLoader.getThemeIconDir(), theme.directory, iconPath)) == null) {
                    String resourcePath = String.format("theme/%s/%s", theme.directory, iconPath);
                    nativeImage = TextureCache.resolveImage(ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)resourcePath));
                }
                if (nativeImage != null && nativeImage.pixels > 0L) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || nativeImage.getWidth() != width || nativeImage.getHeight() != height)) {
                        NativeImage tmp = ImageUtil.getSizedImage(width, height, nativeImage, false);
                        nativeImage.close();
                        nativeImage = tmp;
                    }
                    tex = new DynamicTexture(nativeImage);
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicTexture getScaledCopy(String texName, DynamicTexture original, int width, int height, float alpha) {
        Map<String, DynamicTexture> map = themeImages;
        synchronized (map) {
            try {
                DynamicTexture tex = themeImages.get(texName);
                if (tex == null || !((TextureAccess)tex).journeymap$hasImage() || width != ((TextureAccess)tex).journeymap$getWidth() || height != ((TextureAccess)tex).journeymap$getHeight()) {
                    if (original == null) {
                        Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                        return TextureCache.getTexture(UnknownEntity);
                    }
                    if (!(alpha < 1.0f) && ((TextureAccess)original).journeymap$getWidth() == width && ((TextureAccess)original).journeymap$getHeight() == height) {
                        return original;
                    }
                    tex = new DynamicTexture(ImageUtil.getSizedImage(width, height, original.getPixels(), true));
                    themeImages.put(texName, tex);
                }
                return tex;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unable to get scaled image: {}", (Object)texName, (Object)e);
                return original;
            }
        }
    }

    public static DynamicTexture getColorizedWaypointIcon(String id) {
        ClientWaypointImpl holder = WaypointStore.getInstance().get(id);
        if (holder != null) {
            ResourceLocation location = holder.getTextureResource();
            int color = holder.getIconColor();
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            if (holder.hasCustomIconColor() || "journeymap".equals(location.getNamespace())) {
                NativeImage nativeImage = TextureCache.resolveImage(location);
                if (nativeImage == null) {
                    nativeImage = TextureCache.resolveImage(Waypoint);
                }
                if (colorizedWPIconMap.get(id) == null && nativeImage != null && nativeImage.pixels != 0L) {
                    NativeImage coloredImage = ImageUtil.recolorImage(nativeImage, color);
                    DynamicTexture texture = new DynamicTexture(coloredImage);
                    colorizedWPIconMap.put(id, texture);
                    nativeImage.close();
                    return texture;
                }
                return colorizedWPIconMap.get(id);
            }
            return (DynamicTexture)textureManager.getTexture(location, null);
        }
        return null;
    }

    public static DynamicTexture getPlayerSkin(GameProfile profile) {
        return IgnSkin.getFace(profile);
    }
}

