/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.mod.vanilla.BedBlockProxy;
import journeymap.client.mod.vanilla.BirchLeavesBlockProxy;
import journeymap.client.mod.vanilla.FlowerBlockProxy;
import journeymap.client.mod.vanilla.PetalBlockProxy;
import journeymap.client.mod.vanilla.SpruceLeavesBlockProxy;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.properties.CoreProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CherryLeavesBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public final class VanillaBlockHandler
implements IModBlockHandler {
    ListMultimap<MapColor, BlockFlag> materialFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Class<?>, BlockFlag> blockClassFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Block, BlockFlag> blockFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    HashMap<MapColor, Float> materialAlphas = new HashMap();
    HashMap<Block, Float> blockAlphas = new HashMap();
    HashMap<Class<?>, Float> blockClassAlphas = new HashMap();
    private boolean mapPlants;
    private boolean mapPlantShadows;
    private boolean mapCrops;

    public VanillaBlockHandler() {
        this.preInitialize();
    }

    private void preInitialize() {
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.mapPlants = coreProperties.mapPlants.get();
        this.mapCrops = coreProperties.mapCrops.get();
        this.mapPlantShadows = coreProperties.mapPlantShadows.get();
        this.setFlags(Blocks.BARRIER, BlockFlag.Ignore);
        this.setFlags(Blocks.AIR, BlockFlag.Ignore);
        this.setFlags(Blocks.GLASS, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(TransparentBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(IronBarsBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(StainedGlassPaneBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(StainedGlassBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Blocks.SHORT_GRASS, BlockFlag.Grass);
        if (coreProperties.caveIgnoreGlass.get().booleanValue()) {
            this.setFlags(Blocks.GLASS, BlockFlag.OpenToSky);
        }
        this.setFlags(Blocks.LAVA, Float.valueOf(1.0f), BlockFlag.NoShadow);
        this.setFlags(MapColor.WATER, Float.valueOf(0.25f), BlockFlag.Water, BlockFlag.NoShadow);
        this.setFlags(MapColor.WOOD, BlockFlag.NoTopo);
        this.setFlags(MapColor.PLANT, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(Blocks.BAMBOO, BlockFlag.NoTopo);
        this.setFlags(Blocks.BAMBOO_SAPLING, BlockFlag.NoTopo);
        this.materialAlphas.put(MapColor.ICE, Float.valueOf(0.8f));
        this.setFlags(Blocks.IRON_BARS, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Blocks.FIRE, BlockFlag.NoShadow);
        this.setFlags(Blocks.LADDER, BlockFlag.OpenToSky);
        this.setFlags(Blocks.SNOW, BlockFlag.NoTopo, BlockFlag.NoShadow);
        this.setFlags(Blocks.TRIPWIRE, BlockFlag.Ignore);
        this.setFlags(Blocks.TRIPWIRE_HOOK, BlockFlag.Ignore);
        this.setFlags(Blocks.COBWEB, BlockFlag.OpenToSky, BlockFlag.NoShadow);
        this.setFlags(FenceBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(FenceGateBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(GrassBlock.class, BlockFlag.Grass);
        this.setFlags(PinkPetalsBlock.class, BlockFlag.Grass);
        this.setFlags(RailBlock.class, BlockFlag.NoShadow, BlockFlag.NoTopo);
        this.setFlags(RedStoneWireBlock.class, BlockFlag.Ignore);
        this.setFlags(TorchBlock.class, BlockFlag.Ignore);
        this.setFlags(VineBlock.class, Float.valueOf(0.2f), BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoShadow);
        this.setFlags(BushBlock.class, BlockFlag.Plant);
        this.setFlags(CactusBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(SugarCaneBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(SeagrassBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
    }

    @Override
    public void initialize(BlockMD blockMD) {
        Block block = blockMD.getBlockState().getBlock();
        MapColor mapColor = blockMD.getBlock().defaultMapColor();
        BlockState blockState = blockMD.getBlockState();
        if (blockState.getRenderShape() == RenderShape.INVISIBLE && !(blockState.getBlock() instanceof LiquidBlock)) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
        blockMD.addFlags(this.materialFlags.get((Object)mapColor));
        Float alpha = this.materialAlphas.get(mapColor);
        if (alpha != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (this.blockFlags.containsKey((Object)block)) {
            blockMD.addFlags(this.blockFlags.get((Object)block));
        }
        if ((alpha = this.blockAlphas.get(block)) != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        for (Class parentClass : this.blockClassFlags.keys()) {
            if (!parentClass.isAssignableFrom(block.getClass())) continue;
            blockMD.addFlags(this.blockClassFlags.get((Object)parentClass));
            alpha = this.blockClassAlphas.get(parentClass);
            if (alpha == null) break;
            blockMD.setAlpha(alpha.floatValue());
            break;
        }
        if (block instanceof LiquidBlock) {
            blockMD.addFlags(BlockFlag.Fluid, BlockFlag.NoShadow);
            blockMD.setAlpha(0.7f);
        }
        if (block instanceof BushBlock && blockMD.getBlockState().getProperties().contains(DoublePlantBlock.HALF) && blockMD.getBlockState().getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
            blockMD.addFlags(BlockFlag.Ignore);
        }
        if (block instanceof CropBlock) {
            blockMD.addFlags(BlockFlag.Crop);
        }
        if (block instanceof FlowerBlock || block instanceof FlowerPotBlock) {
            blockMD.setBlockColorProxy(FlowerBlockProxy.INSTANCE);
        }
        if (block instanceof BedBlock) {
            blockMD.setBlockColorProxy(BedBlockProxy.INSTANCE);
        }
        if (block instanceof PinkPetalsBlock) {
            blockMD.setBlockColorProxy(PetalBlockProxy.getInstance());
        }
        String uid = blockMD.getBlockId();
        if (LeavesBlock.class.isAssignableFrom(block.getClass()) || uid.toLowerCase().contains("leaves")) {
            BlockColors blockColors;
            int color;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && (color = (blockColors = mc.getBlockColors()).getColor(blockState, (BlockAndTintGetter)mc.level, BlockPos.ZERO, 0)) != -1) {
                blockMD.addFlags(BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoTopo);
            }
            blockMD.removeFlags(BlockFlag.Plant);
            boolean vanilla = uid.startsWith("minecraft:");
            if (block instanceof CherryLeavesBlock || vanilla && uid.toLowerCase().contains("azalea")) {
                blockMD.removeFlags(BlockFlag.Foliage);
            }
            if (vanilla && uid.toLowerCase().contains("spruce")) {
                blockMD.removeFlags(BlockFlag.Foliage);
                blockMD.setBlockColorProxy(SpruceLeavesBlockProxy.getInstance());
            }
            if (vanilla && uid.toLowerCase().contains("birch")) {
                blockMD.removeFlags(BlockFlag.Foliage);
                blockMD.setBlockColorProxy(BirchLeavesBlockProxy.getInstance());
            }
        }
        if (uid.toLowerCase().contains("log") || uid.toLowerCase().contains("wood")) {
            blockMD.addFlags(BlockFlag.NoTopo);
        }
        if (uid.equals("minecraft:bell")) {
            blockMD.setBlockColorProxy(ModBlockDelegate.INSTANCE.getMaterialBlockColorProxy());
            return;
        }
        if (blockMD.isVanillaBlock()) {
            return;
        }
        if (uid.toLowerCase().contains("torch")) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
    }

    public void postInitialize(BlockMD blockMD) {
        if (blockMD.hasFlag(BlockFlag.Crop)) {
            blockMD.removeFlags(BlockFlag.Plant);
        }
        if (blockMD.hasAnyFlag(BlockMD.FlagsPlantAndCrop)) {
            if (!this.mapPlants && blockMD.hasFlag(BlockFlag.Plant) || !this.mapCrops && blockMD.hasFlag(BlockFlag.Crop)) {
                blockMD.addFlags(BlockFlag.Ignore);
            } else if (!this.mapPlantShadows) {
                blockMD.addFlags(BlockFlag.NoShadow);
            }
        }
        if (blockMD.isIgnore()) {
            blockMD.removeFlags(BlockMD.FlagsNormal);
        }
    }

    private void setFlags(MapColor material, BlockFlag ... flags) {
        this.materialFlags.putAll((Object)material, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(MapColor material, Float alpha, BlockFlag ... flags) {
        this.materialAlphas.put(material, alpha);
        this.setFlags(material, flags);
    }

    private void setFlags(Class parentClass, BlockFlag ... flags) {
        this.blockClassFlags.putAll((Object)parentClass, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Class parentClass, Float alpha, BlockFlag ... flags) {
        this.blockClassAlphas.put(parentClass, alpha);
        this.setFlags(parentClass, flags);
    }

    private void setFlags(Block block, BlockFlag ... flags) {
        this.blockFlags.putAll((Object)block, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Block block, Float alpha, BlockFlag ... flags) {
        this.blockAlphas.put(block, alpha);
        this.setFlags(block, flags);
    }
}

