/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers.keymapping;

import com.mojang.blaze3d.platform.InputConstants;
import journeymap.client.Constants;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;

public class KeyBindingAction {
    UpdateAwareKeyBinding keyBinding;
    Runnable action;

    public KeyBindingAction(UpdateAwareKeyBinding keyBinding, Runnable action) {
        this.keyBinding = keyBinding;
        this.action = action;
    }

    public boolean isActive(int key, boolean useContext, InputConstants.Type type) {
        if (useContext) {
            return this.keyBinding.isActiveAndMatches(type.getOrCreate(key));
        }
        return this.keyBinding.getKeyValue().getValue() == key && this.keyBinding.modifierActive();
    }

    public Runnable getAction() {
        return this.action;
    }

    public UpdateAwareKeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    public int order() {
        return this.keyBinding.getModifier().ordinal();
    }

    public String toString() {
        return "KeyBindingAction{" + this.keyBinding.getTranslatedName().getString().toUpperCase() + " = " + Constants.getString(this.keyBinding.getText()) + "}";
    }
}

