/*
 * Decompiled with CFR 0.152.
 */
package forge.com.legobmw99.BetterThanMending.core;

import forge.com.legobmw99.BetterThanMending.core.util.Utilities;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class Common {
    public static final String MODID = "betterthanmending";

    public static boolean willMend(Player player, ItemStack stack) {
        return player.isShiftKeyDown() && stack.isDamaged() && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP) && Utilities.getPlayerXP(player) > 2;
    }

    private static void repair(ServerPlayer player, ItemStack stack, int xp, float ratio) {
        int couldRepair = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)player.serverLevel(), (ItemStack)stack, (int)((int)((float)xp * ratio)));
        int toRepair = Math.min(couldRepair, stack.getDamageValue());
        stack.setDamageValue(stack.getDamageValue() - toRepair);
        Utilities.addPlayerXP((Player)player, -xp);
    }

    public static void doMend(ServerPlayer player, ItemStack stack, float ratio) {
        int playerXP = Utilities.getPlayerXP((Player)player);
        if (playerXP >= 30 && stack.getDamageValue() >= 40) {
            Common.repair(player, stack, 20, ratio);
        } else if (playerXP >= 2) {
            Common.repair(player, stack, 2, ratio);
        }
    }
}

