/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CGBlockStateGenerator
extends BlockStateGenerator {
    public CGBlockStateGenerator(ResourceCache cache) {
        super("connectedglass", cache);
    }

    public void generate() {
        for (CGGlassType type : CGGlassType.values()) {
            this.blockState((Block)type.getBlock()).emptyVariant(builder -> builder.model(type.getRegistryName()));
            for (DyeColor color : DyeColor.values()) {
                this.blockState((Block)type.getBlock(color)).emptyVariant(builder -> builder.model(type.getRegistryName(color)));
            }
        }
        for (CGGlassType type : CGGlassType.values()) {
            if (!type.hasPanes) continue;
            String identifier = type.getPaneRegistryName();
            this.createPaneBlockState(identifier, (Block)type.getPane());
            for (DyeColor color : DyeColor.values()) {
                identifier = type.getPaneRegistryName(color);
                this.createPaneBlockState(identifier, (Block)type.getPane(color));
            }
        }
    }

    private void createPaneBlockState(String identifier, Block pane) {
        this.blockState(pane).unconditionalMultipart(variant -> variant.model(identifier + "_post")).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true}), variant -> variant.model(identifier + "_side_north")).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true}), variant -> variant.model(identifier + "_side_east", 0, 90)).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true}), variant -> variant.model(identifier + "_side_south")).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true}), variant -> variant.model(identifier + "_side_west", 0, 90)).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{false}), variant -> variant.model(identifier + "_noside")).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{false}), variant -> variant.model(identifier + "_noside_alt")).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{false}), variant -> variant.model(identifier + "_noside_alt", 0, 90)).multipart(condition -> condition.requireProperty((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{false}), variant -> variant.model(identifier + "_noside", 0, 270));
    }
}

