/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.client.config.ConfigUtil;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.ContainerFilterBox;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Unique
    private ContainerFilterBox nemosInventorySorting$containerFilterBox;
    @Unique
    private EditBox nemosInventorySorting$searchBox;
    @Unique
    private static final ResourceLocation HIGHLIGHTED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final ResourceLocation DIMMED_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");

    @Shadow
    public abstract AbstractContainerMenu getMenu();

    protected AbstractContainerScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        if (this.nemosInventorySorting$shouldHaveSearchBox()) {
            List<ComponentConfig> configs = ConfigUtil.readConfigs();
            Optional<ComponentConfig> optionalComponentConfig = ConfigUtil.getConfigs(configs, Constants.ITEM_FILTER);
            if (optionalComponentConfig.isEmpty()) {
                this.nemosInventorySorting$createSearchBox(Constants.X_OFFSET_ITEM_FILTER, Constants.Y_OFFSET_ITEM_FILTER, Constants.ITEM_FILTER_WIDTH, Constants.ITEM_FILTER_HEIGHT);
                return;
            }
            ComponentConfig config = optionalComponentConfig.get();
            if (!config.isEnabled()) {
                return;
            }
            int yOffset = config.yOffset() != null ? config.yOffset() : Constants.Y_OFFSET_ITEM_FILTER;
            this.nemosInventorySorting$createSearchBox(config.xOffset(), yOffset, config.width(), config.height());
        }
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$containerFilterBox = new ContainerFilterBox(this.font, this.leftPos, this.topPos, xOffset, yOffset, width, height);
        this.nemosInventorySorting$searchBox = this.nemosInventorySorting$containerFilterBox.getSearchBox();
        this.addWidget((GuiEventListener)this.nemosInventorySorting$searchBox);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$shouldHaveSearchBox() && this.nemosInventorySorting$searchBox != null && this.nemosInventorySorting$searchBox.isFocused() && keyCode != 256) {
            cir.setReturnValue((Object)this.nemosInventorySorting$searchBox.keyPressed(keyCode, scanCode, modifiers));
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveSearchBox() || this.nemosInventorySorting$searchBox == null) {
            return;
        }
        this.nemosInventorySorting$searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        String filter = this.nemosInventorySorting$searchBox.getValue();
        if (!filter.isEmpty()) {
            Map<Boolean, List<Slot>> filteredSlotMap = this.nemosInventorySorting$containerFilterBox.filterSlots((NonNullList<Slot>)this.getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(false, filteredSlotMap.get(true), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(true, filteredSlotMap.get(false), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveSearchBox() {
        return this.getMenu() instanceof ChestMenu || this.getMenu() instanceof ShulkerBoxMenu;
    }

    @Unique
    private void nemosInventorySorting$markSlots(boolean shouldFillGradient, List<Slot> slots, GuiGraphics guiGraphics, ResourceLocation texture) {
        for (Slot slot : slots) {
            int xPos = this.leftPos + slot.x;
            int yPos = this.topPos + slot.y;
            guiGraphics.blitSprite(texture, xPos, yPos, 16, 16);
            if (!shouldFillGradient) continue;
            guiGraphics.fillGradient(RenderType.guiOverlay(), xPos, yPos, xPos + 16, yPos + 16, -2139062142, -2139062142, 0);
        }
    }
}

