/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.client.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;

public class ConfigUtil {
    private static final Gson GSON = new Gson();
    private static final String DIRECTORY_PATH = "config/nemos-inventory-sorting/";
    private static final String FILE_PATH = "config/nemos-inventory-sorting/config.json";
    private static final Type configType = new TypeToken<List<ComponentConfig>>(){}.getType();

    public static void writeConfigs(List<ComponentConfig> config) {
        if (Files.exists(Paths.get(FILE_PATH, new String[0]), new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(Paths.get(DIRECTORY_PATH, new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while creating directories:\n", (Throwable)e);
        }
        try (FileWriter writer = new FileWriter(FILE_PATH);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred while writing the config:\n", (Throwable)e);
        }
    }

    public static List<ComponentConfig> readConfigs() {
        List list;
        FileReader reader = new FileReader(FILE_PATH);
        try {
            list = (List)GSON.fromJson((Reader)reader, configType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Constants.LOG.error("An error occurred while reading the config:\n", (Throwable)e);
                return List.of();
            }
        }
        reader.close();
        return list;
    }

    public static Optional<ComponentConfig> getConfigs(List<ComponentConfig> configsList, String componentName) {
        return configsList.stream().filter(config -> config.componentName().equals(componentName)).findFirst();
    }
}

