/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.payloads;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.patreon.TrailsManager;
import dev.shadowsoffire.placebo.patreon.WingsManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PatreonDisablePayload(CosmeticType cosmetic, UUID id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PatreonDisablePayload> TYPE = new CustomPacketPayload.Type(Placebo.loc("patreon_disable"));
    public static final StreamCodec<FriendlyByteBuf, PatreonDisablePayload> CODEC = StreamCodec.composite(CosmeticType.STREAM_CODEC, PatreonDisablePayload::cosmetic, (StreamCodec)UUIDUtil.STREAM_CODEC, PatreonDisablePayload::id, PatreonDisablePayload::new);

    public CustomPacketPayload.Type<PatreonDisablePayload> type() {
        return TYPE;
    }

    public static enum CosmeticType {
        TRAILS,
        WINGS;

        public static final IntFunction<CosmeticType> BY_ID;
        public static final StreamCodec<ByteBuf, CosmeticType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])CosmeticType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static class Provider
    implements PayloadProvider<PatreonDisablePayload> {
        @Override
        public CustomPacketPayload.Type<PatreonDisablePayload> getType() {
            return TYPE;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, PatreonDisablePayload> getCodec() {
            return CODEC;
        }

        @Override
        public void handle(PatreonDisablePayload msg, IPayloadContext ctx) {
            if (ctx.flow() == PacketFlow.SERVERBOUND) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PatreonDisablePayload(msg.cosmetic(), ctx.player().getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                Set<UUID> set;
                switch (msg.cosmetic().ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Set<UUID> set2 = TrailsManager.DISABLED;
                        break;
                    }
                    case 1: {
                        Set<UUID> set2 = set = WingsManager.DISABLED;
                    }
                }
                if (set.contains(msg.id)) {
                    set.remove(msg.id);
                } else {
                    set.add(msg.id);
                }
            }
        }

        @Override
        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        @Override
        public Optional<PacketFlow> getFlow() {
            return Optional.empty();
        }

        @Override
        public String getVersion() {
            return "1";
        }
    }
}

