/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.common.Tags;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CroptopiaBiomeTagProvider
extends TagsProvider<Biome> {
    public CroptopiaBiomeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, Registries.BIOME, provider, "croptopia", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.addCrops(provider);
        this.addTrees(provider);
        this.tag(Tags.HAS_SALT).addTag(Tags.Biomes.IS_RIVER).addTag(Tags.Biomes.IS_OCEAN).addTag(Tags.Biomes.IS_DEEP_OCEAN).addTag(Tags.Biomes.IS_SHALLOW_OCEAN).addTag(Tags.Biomes.IS_FOREST).addTag(Tags.Biomes.IS_DESERT).addTag(Tags.Biomes.IS_PLAINS).addTag(Tags.Biomes.IS_TAIGA).addTag(Tags.Biomes.IS_BADLANDS).addTag(Tags.Biomes.IS_BIRCH_FOREST).addTag(Tags.Biomes.IS_HILL).addTag(Tags.Biomes.IS_JUNGLE);
    }

    private void addTrees(HolderLookup.Provider provider) {
        this.tag(Tags.HAS_ORANGE).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.SUNFLOWER_PLAINS, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe"));
        this.tag(Tags.HAS_DRAGONFRUIT).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_KUMQUAT).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley"));
        this.tag(Tags.HAS_BANANA).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_PLUM).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_FOREST, Biomes.FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("maple_woods")).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("minecraft:flower_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("minecraft:windswept_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard"));
        this.tag(Tags.HAS_DATE).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_CASHEW).add(Biomes.DARK_FOREST).addOptional(CroptopiaBiomeTagProvider.bopID("bayou")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:dacite_ridges")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow"));
        this.tag(Tags.HAS_MANGO).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_COCONUT).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_APRICOT).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_NUTMEG).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("bog")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("traverse:mini_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_PERSIMMON).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.bopID("maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_ALMOND).add(Biomes.DARK_FOREST).addOptional(CroptopiaBiomeTagProvider.bopID("forested_field")).addOptional(CroptopiaBiomeTagProvider.bopID("maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:dacite_ridges")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow"));
        this.tag(Tags.HAS_AVOCADO).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_FIG).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.bopID("maple_woods")).addOptional(CroptopiaBiomeTagProvider.bopID("mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_CINNAMON).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("rainforest")).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:white_mangrove_marshes")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cypress_swamplands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_PEACH).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.bopID("jacaranda_glade")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe"));
        this.tag(Tags.HAS_APPLE).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.bopID("jacaranda_glade")).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:prairie")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe"));
        this.tag(Tags.HAS_PEAR).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_GRAPEFRUIT).add(new ResourceKey[]{Biomes.SPARSE_JUNGLE, Biomes.JUNGLE}).addOptional(CroptopiaBiomeTagProvider.bopID("wetland")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_islands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle"));
        this.tag(Tags.HAS_STARFRUIT).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("tropics")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe"));
        this.tag(Tags.HAS_NECTARINE).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.bopID("seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_LEMON).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_CHERRY).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_LIME).addOptional(CroptopiaBiomeTagProvider.bopID("orchard")).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.WINDSWEPT_FOREST}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley"));
        this.tag(Tags.HAS_PECAN).add(Biomes.DARK_FOREST).addOptional(CroptopiaBiomeTagProvider.bopID("seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:dacite_ridges")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga"));
        this.tag(Tags.HAS_WALNUT).add(Biomes.DARK_FOREST).addOptional(CroptopiaBiomeTagProvider.bopID("seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:dacite_ridges")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe"));
    }

    private void addCrops(HolderLookup.Provider provider) {
        this.tag(Tags.HAS_ARTICHOKE).add(Biomes.SWAMP).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cypress_swamplands")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:white_mangrove_marshes")).addOptional(CroptopiaBiomeTagProvider.key("terralith:mirage_isles")).addOptional(CroptopiaBiomeTagProvider.key("terralith:orchid_swamp")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:marsh")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bayou")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog"));
        this.tag(Tags.HAS_ASPARAGUS).add(Biomes.SWAMP).addOptional(CroptopiaBiomeTagProvider.key("terralith:mirage_isles")).addOptional(CroptopiaBiomeTagProvider.key("terralith:orchid_swamp")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:marsh")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bayou")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog"));
        this.tag(Tags.HAS_BARLEY).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field"));
        this.tag(Tags.HAS_BASIL).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_BELLPEPPER).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning"));
        this.tag(Tags.HAS_BLACKBEAN).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_BLACKBERRY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:black_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:zelkova_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:forested_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lush_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_maple_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:yosemite_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_BLUEBERRY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_BROCCOLI).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_CABBAGE).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_CANTALOUPE).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_CAULIFLOWER).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_CELERY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_CHILE_PEPPER).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_COFFEE_BEANS).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_CORN).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:allium_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:amaranth_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_valley")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coconino_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:prairie")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:rose_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:sierra_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cold_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:scarlet_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_CRANBERRY).add(Biomes.SWAMP).addOptional(CroptopiaBiomeTagProvider.key("terralith:mirage_isles")).addOptional(CroptopiaBiomeTagProvider.key("terralith:orchid_swamp")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:marsh")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bayou")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog"));
        this.tag(Tags.HAS_CUCUMBER).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:allium_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:amaranth_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_valley")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coconino_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:prairie")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:rose_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:sierra_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_CURRANT).add(Biomes.SWAMP).addOptional(CroptopiaBiomeTagProvider.key("terralith:mirage_isles")).addOptional(CroptopiaBiomeTagProvider.key("terralith:orchid_swamp")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:marsh")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bayou")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog"));
        this.tag(Tags.HAS_EGGPLANT).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_ELDERBERRY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_GARLIC).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:guiana_shield")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_GINGER).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_GRAPE).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_GREENBEAN).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:allium_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:amaranth_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_valley")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coconino_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:prairie")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:rose_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:sierra_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_GREENONION).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_HONEYDEW).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_HOPS).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_KALE).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:allium_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:amaranth_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_valley")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coconino_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:prairie")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:rose_fields")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:sierra_badlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_KIWI).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:araucaria_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:baobab_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_LEEK).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_LETTUCE).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_MUSTARD).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_OAT).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_OLIVE).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_ONION).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:forested_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lush_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_maple_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:yosemite_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_PEANUT).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:guiana_shield")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_PEPPER).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:ashen_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_PINEAPPLE).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:guiana_shield")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_RADISH).add(new ResourceKey[]{Biomes.FLOWER_FOREST, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_RASPBERRY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:aspen_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:black_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:borealis_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cherry_blossom_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:cika_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:ebony_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:forgotten_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_oak_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:redwood_thicket")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:fragment_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:twilight_meadow")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:weeping_witch_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:temperate_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:zelkova_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_RHUBARB).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:guiana_shield")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_RICE).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_RUTABAGA).add(new ResourceKey[]{Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.SAVANNA_PLATEAU, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:araucaria_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:baobab_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:black_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:maple_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:autumnal_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_taiga")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:frosted_coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:zelkova_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_SAGUARO).add(Biomes.DESERT).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:atacama_desert")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:windswept_dunes")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:windswept_desert")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:mojave_desert")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:red_rock_valley")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:firecracker_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:ancient_sands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:bryce_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:desert_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:desert_oasis")).addOptional(CroptopiaBiomeTagProvider.key("terralith:desert_spires")).addOptional(CroptopiaBiomeTagProvider.key("terralith:hot_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:painted_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:red_oasis")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sandstone_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:warped_mesa"));
        this.tag(Tags.HAS_SOYBEAN).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_SPINACH).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_SQUASH).add(new ResourceKey[]{Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cold_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:forested_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lush_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("terralith:scarlet_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:siberian_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_maple_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:snowy_shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:yosemite_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_STRAWBERRY).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:alpine_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_plateau")).addOptional(CroptopiaBiomeTagProvider.key("terralith:blooming_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:steppe")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:valley_clearing")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_SWEETPOTATO).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS}).addOptional(CroptopiaBiomeTagProvider.key("terralith:cold_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:scarlet_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bog")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:coniferous_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:field")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fir_cleaning")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:maple_woods")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:tundra"));
        this.tag(Tags.HAS_TEA_LEAVES).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_TOMATILLO).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_TOMATO).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.GROVE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:birch_taiga")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cloud_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:lavender_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:moonlight_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:temperate_highlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:bamboo_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:cherry_blossom_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mediterranean_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:mystic_grove")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:pumpkin_patch")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:redwood_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:seasonal_orchard")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:woodland"));
        this.tag(Tags.HAS_TURMERIC).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:araucaria_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:baobab_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_TURNIP).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:crag_gardens")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:guiana_shield")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:jacaranda_forest")).addOptional(CroptopiaBiomeTagProvider.key("biomeswevegone:tropical_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_VANILLA).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_canyon")).addOptional(CroptopiaBiomeTagProvider.key("terralith:amethyst_rainforest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:jungle_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_jungle")).addOptional(CroptopiaBiomeTagProvider.key("terralith:tropical_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:floodplain")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:fungal_jungle")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rainforest")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:rocky_rainforest"));
        this.tag(Tags.HAS_YAM).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:cold_shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:rocky_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_grove")).addOptional(CroptopiaBiomeTagProvider.key("terralith:sakura_valley")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("terralith:scarlet_mountains")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shield")).addOptional(CroptopiaBiomeTagProvider.key("terralith:shrubland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_forest")).addOptional(CroptopiaBiomeTagProvider.key("terralith:wintry_lowlands")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
        this.tag(Tags.HAS_ZUCCHINI).add(new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}).addOptional(CroptopiaBiomeTagProvider.key("terralith:arid_highlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:brushland")).addOptional(CroptopiaBiomeTagProvider.key("terralith:fractured_savanna")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_badlands")).addOptional(CroptopiaBiomeTagProvider.key("terralith:savanna_slopes")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:dryland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:lush_savanna")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:scrubland")).addOptional(CroptopiaBiomeTagProvider.key("biomesoplenty:wooded_scrubland"));
    }

    private static ResourceLocation key(String name) {
        return ResourceLocation.parse((String)name);
    }

    private static ResourceLocation biomeswevegoneID(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"biomeswevegone", (String)name);
    }

    private static ResourceLocation bopID(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)name);
    }
}

