/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateHorizontally(VoxelShape shape, Direction direction) {
        Preconditions.checkArgument((boolean)direction.getAxis().isHorizontal());
        return shape.toAabbs().stream().map(box -> VoxelShapeHelper.createRotatedShape(box, direction)).reduce(Shapes.empty(), VoxelShapeHelper::join);
    }

    public static VoxelShape combine(List<VoxelShape> shapes) {
        return shapes.stream().reduce(Shapes.empty(), VoxelShapeHelper::join).optimize();
    }

    private static VoxelShape join(VoxelShape a, VoxelShape b) {
        return Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR);
    }

    private static VoxelShape createRotatedShape(AABB box, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> Shapes.box((double)(1.0 - box.maxX), (double)box.minY, (double)(1.0 - box.maxZ), (double)(1.0 - box.minX), (double)box.maxY, (double)(1.0 - box.minZ));
            case Direction.NORTH -> Shapes.box((double)box.minZ, (double)box.minY, (double)(1.0 - box.maxX), (double)box.maxZ, (double)box.maxY, (double)(1.0 - box.minX));
            case Direction.SOUTH -> Shapes.box((double)(1.0 - box.maxZ), (double)box.minY, (double)box.minX, (double)(1.0 - box.minZ), (double)box.maxY, (double)box.maxX);
            default -> Shapes.box((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ);
        };
    }
}

