/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.widget;

import com.mrcrayfish.furniture.refurbished.client.gui.IOverrideGetEntry;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.util.Mth;

public class ComputerSelectionList<E extends ObjectSelectionList.Entry<E>>
extends ObjectSelectionList<E>
implements IOverrideGetEntry<E> {
    private static final int OUTLINE_SIZE = 1;
    protected int contentPadding = 2;
    protected int scrollBarWidth = 6;
    protected int outlineColour = -12107714;
    protected int backgroundColour = -14277082;
    protected int scrollBarColour = -12107714;
    protected int scrollBarHighlightColour = -13423059;
    protected int itemSpacing = 2;
    protected boolean scrolling;

    public ComputerSelectionList(int width, int height, int x, int y, int itemHeight) {
        super(Minecraft.getInstance(), width, height, y, itemHeight);
        this.setPosition(x, y);
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.setSize(this.width, this.height);
    }

    public void setContentPadding(int contentPadding) {
        this.contentPadding = contentPadding;
    }

    public void setScrollBarWidth(int scrollBarWidth) {
        this.scrollBarWidth = scrollBarWidth;
    }

    public void setOutlineColour(int outlineColour) {
        this.outlineColour = outlineColour;
    }

    public void setBackgroundColour(int backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public void setScrollBarColour(int scrollBarColour) {
        this.scrollBarColour = scrollBarColour;
    }

    public void setScrollBarHighlightColour(int scrollBarHighlightColour) {
        this.scrollBarHighlightColour = scrollBarHighlightColour;
    }

    public void setItemSpacing(int itemSpacing) {
        this.itemSpacing = itemSpacing;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight()) && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth());
    }

    public int getRowWidth() {
        return this.getRowRight() - this.getRowLeft();
    }

    public int getRowLeft() {
        return this.getX() + 1 + this.contentPadding;
    }

    public int getRowRight() {
        if (this.getMaxScroll() > 0) {
            return this.getX() + this.getWidth() - this.contentPadding - 1 - this.contentPadding - this.scrollBarWidth - this.contentPadding - 1;
        }
        return this.getX() + this.getWidth() - this.contentPadding - 1;
    }

    protected int getRowTop(int index) {
        return this.getY() + 1 + this.contentPadding - (int)this.getScrollAmount() + index * this.itemHeight + index * this.itemSpacing;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - this.scrollBarWidth - this.contentPadding - 1;
    }

    private int getScrollbarHeight() {
        int scrollAreaHeight = this.getScrollAreaHeight();
        int scrollBarHeight = (int)((float)Mth.square((int)scrollAreaHeight) / (float)this.getMaxPosition());
        return Mth.clamp((int)scrollBarHeight, (int)32, (int)scrollAreaHeight);
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height;
    }

    public int getScrollAreaHeight() {
        return this.height - 2 - this.contentPadding * 2;
    }

    public int getScrollAreaTop() {
        return this.getY() + 1 + this.contentPadding;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.height + this.contentPadding * 2 + 2);
    }

    protected int getMaxPosition() {
        return this.getItemCount() * (this.itemHeight + this.itemSpacing) - this.itemSpacing;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.outlineColour);
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, this.backgroundColour);
        graphics.enableScissor(this.getRowLeft() - 1, this.getY() + 1, this.getRowRight() + 1, this.getY() + this.getHeight() - 1);
        this.renderListItems(graphics, mouseX, mouseY, partialTick);
        graphics.disableScissor();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            graphics.fill(this.getScrollbarPosition() - this.contentPadding - 1, this.getY() + 1, this.getScrollbarPosition() - this.contentPadding, this.getY() + this.getHeight() - 1, this.outlineColour);
            int scrollBarStart = this.getScrollbarPosition();
            int scrollBarEnd = scrollBarStart + this.scrollBarWidth;
            int scrollBarHeight = this.getScrollbarHeight();
            int scrollBarTop = (int)((double)this.getScrollAreaTop() + (double)(this.getScrollAreaHeight() - this.getScrollbarHeight()) * (this.getScrollAmount() / (double)maxScroll));
            int scrollBarColour = ScreenHelper.isMouseWithinBounds(mouseX, mouseY, scrollBarStart, scrollBarTop, this.scrollBarWidth, scrollBarHeight) ? this.scrollBarHighlightColour : this.scrollBarColour;
            graphics.fill(scrollBarStart, scrollBarTop, scrollBarEnd, scrollBarTop + scrollBarHeight, scrollBarColour);
        }
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int startIndex;
        int rowTop;
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int rowHeight = this.itemHeight;
        int rowCount = this.getItemCount();
        for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.contentPadding) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
            this.renderItem(graphics, mouseX, mouseY, partialTick, i, rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    protected void renderSelection(GuiGraphics graphics, int top, int rowWidth, int itemHeight, int outlineColour, int innerColour) {
        int start = this.getRowLeft();
        int end = this.getRowRight();
        graphics.fill(start - 1, top - 1, end + 1, top + itemHeight + 1, outlineColour);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.getScrollbarPosition(), this.getScrollAreaTop(), 6, this.getScrollAreaHeight());
    }

    public boolean mouseDragged(double $$0, double $$1, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.getFocused() != null && this.isDragging() && ((ObjectSelectionList.Entry)this.getFocused()).mouseDragged($$0, $$1, button, deltaX, deltaY)) {
                return true;
            }
            if (this.scrolling) {
                double unitsPerScroll = (double)this.getMaxScroll() / (double)(this.getScrollAreaHeight() - this.getScrollbarHeight());
                this.setScrollAmount(this.getScrollAmount() + deltaY * unitsPerScroll);
                return true;
            }
        }
        return false;
    }

    @Override
    public E getEntry(double mouseX, double mouseY) {
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            int startIndex;
            int rowTop;
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getRowWidth();
            int rowHeight = this.itemHeight;
            int rowCount = this.getItemCount();
            for (int i = startIndex = Math.max(0, (int)((this.getScrollAmount() - (double)this.contentPadding) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.getRowTop(i)) <= this.getY() + this.getHeight(); ++i) {
                if (!ScreenHelper.isMouseWithinBounds(mouseX, mouseY, rowLeft, rowTop, rowWidth, rowHeight)) continue;
                return (E)((ObjectSelectionList.Entry)this.getEntry(i));
            }
        }
        return null;
    }
}

