/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.item.custom;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.BenchedMoves;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.pokemon.moves.LearnsetQuery;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.config.SimpleTMsConfig;
import dragomordor.simpletms.item.SimpleTMsItem;
import dragomordor.simpletms.item.api.PokemonSelectingItemNonBattle;
import dragomordor.simpletms.util.FailureMessage;
import dragomordor.simpletms.util.MiscUtilsKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010(\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b(\u0010\u0017J5\u00101\u001a\u0002002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010+\u001a\u00020*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0,2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b1\u00102R\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u00103\u001a\u0004\b4\u00105R\u001a\u0010\u0006\u001a\u00020\u00058\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u00106\u001a\u0004\b7\u00108R\u0014\u0010\u0007\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00106\u00a8\u00069"}, d2={"Ldragomordor/simpletms/item/custom/MoveLearnItem;", "Ldragomordor/simpletms/item/SimpleTMsItem;", "Ldragomordor/simpletms/item/api/PokemonSelectingItemNonBattle;", "", "moveName", "", "isTR", "isCustomMove", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Ljava/lang/String;ZZLnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "Lnet/minecraft/network/chat/Component;", "getName", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/Component;", "itemStack2", "isValidRepairItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "stack", "Lnet/minecraft/world/InteractionResultHolder;", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "moveToTeach", "canPokemonLearnMove", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/moves/MoveTemplate;)Z", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipContext", "", "list", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Ljava/lang/String;", "getMoveName$common", "()Ljava/lang/String;", "Z", "isTR$common", "()Z", "common"})
@SourceDebugExtension(value={"SMAP\nMoveLearnItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveLearnItem.kt\ndragomordor/simpletms/item/custom/MoveLearnItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,629:1\n1761#2,3:630\n1761#2,3:633\n*S KotlinDebug\n*F\n+ 1 MoveLearnItem.kt\ndragomordor/simpletms/item/custom/MoveLearnItem\n*L\n293#1:630,3\n294#1:633,3\n*E\n"})
public final class MoveLearnItem
extends SimpleTMsItem
implements PokemonSelectingItemNonBattle {
    @NotNull
    private final String moveName;
    private final boolean isTR;
    private final boolean isCustomMove;

    public MoveLearnItem(@NotNull String moveName, boolean isTR, boolean isCustomMove, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.moveName = moveName;
        this.isTR = isTR;
        this.isCustomMove = isCustomMove;
    }

    @NotNull
    public final String getMoveName$common() {
        return this.moveName;
    }

    public final boolean isTR$common() {
        return this.isTR;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (!this.isCustomMove) {
            MutableComponent mutableComponent;
            MutableComponent localizedMoveName = MiscUtilsKt.fromLang("cobblemon", "move." + this.moveName, new Object[0]);
            if (this.isTR) {
                var4_3 = new Object[1];
                Intrinsics.checkNotNull((Object)localizedMoveName);
                var4_3[0] = localizedMoveName;
                mutableComponent = MiscUtilsKt.fromLang("simpletms", "item.tr_move", var4_3);
            } else {
                var4_3 = new Object[1];
                Intrinsics.checkNotNull((Object)localizedMoveName);
                var4_3[0] = localizedMoveName;
                mutableComponent = MiscUtilsKt.fromLang("simpletms", "item.tm_move", var4_3);
            }
            MutableComponent itemNameComponent = mutableComponent;
            Intrinsics.checkNotNull((Object)itemNameComponent);
            return (Component)itemNameComponent;
        }
        Component component = super.getName(itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return component;
    }

    public boolean isValidRepairItem(@NotNull ItemStack itemStack, @NotNull ItemStack itemStack2) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)itemStack2, (String)"itemStack2");
        if (SimpleTMs.INSTANCE.getConfig().getTmRepairable() && !this.isTR && Intrinsics.areEqual((Object)itemStack2.getItem(), (Object)Items.DIAMOND_BLOCK)) {
            return true;
        }
        return super.isValidRepairItem(itemStack, itemStack2);
    }

    @Override
    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return this.canPokemonLearnMove(pokemon);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        String moveName = this.moveName;
        boolean isTR = this.isTR;
        MoveTemplate moveToTeach = Moves.getByName((String)moveName);
        if (moveToTeach == null) {
            player.displayClientMessage(FailureMessage.Companion.getFailureMessage(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        MutableComponent moveTranslatedName = moveToTeach.getDisplayName();
        boolean TMusuable = SimpleTMs.INSTANCE.getConfig().getTmsUsable();
        boolean TRusuable = SimpleTMs.INSTANCE.getConfig().getTrsUsable();
        if (!TMusuable && !isTR || !TRusuable && isTR) {
            String errorKey = isTR ? "error.not_usable.trs_disabled" : "error.not_usable.tms_disabled";
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", errorKey, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            player.displayClientMessage(FailureMessage.Companion.getFailureMessage(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        if (!this.canPokemonLearnMove(pokemon, moveToTeach)) {
            player.displayClientMessage(FailureMessage.Companion.getFailureMessage(), true);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        Object[] objectArray = new Object[]{pokemon.getSpecies().getTranslatedName(), moveTranslatedName};
        MutableComponent successMessage = MiscUtilsKt.fromLang("simpletms", "success.learned", objectArray);
        player.displayClientMessage((Component)successMessage, true);
        MoveSet currentMoves = pokemon.getMoveSet();
        BenchedMoves benchedMoves = pokemon.getBenchedMoves();
        boolean bl = currentMoves.hasSpace() ? currentMoves.add(moveToTeach.create()) : benchedMoves.add(new BenchedMove(moveToTeach, 0));
        player.playNotifySound(SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.isCreative()) {
            if (isTR) {
                stack.shrink(1);
            } else {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
        int cooldownTicks = SimpleTMs.INSTANCE.getConfig().getTmCoolDownTicks();
        if (!player.isCreative() && !isTR && stack.getCount() > 0 && cooldownTicks > 0) {
            player.getCooldowns().addCooldown((Item)this, cooldownTicks);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world instanceof ServerLevel && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            InteractionResultHolder interactionResultHolder = this.use(serverPlayer, itemStack);
            if (interactionResultHolder == null) {
                InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)user.getItemInHand(hand));
                interactionResultHolder = interactionResultHolder2;
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            }
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    private final boolean canPokemonLearnMove(Pokemon pokemon, MoveTemplate moveToTeach) {
        SimpleTMsConfig cfg;
        MutableComponent moveTranslated;
        MutableComponent translatedName;
        block20: {
            block19: {
                boolean bl;
                block18: {
                    Move it;
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    BenchedMoves benchedMoves;
                    block17: {
                        MoveSet currentMoves = pokemon.getMoveSet();
                        benchedMoves = pokemon.getBenchedMoves();
                        translatedName = pokemon.getSpecies().getTranslatedName();
                        moveTranslated = moveToTeach.getDisplayName();
                        cfg = SimpleTMs.INSTANCE.getConfig();
                        $this$any$iv = currentMoves.getMoves();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Move)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)moveToTeach.getName())) continue;
                                bl2 = true;
                                break block17;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block19;
                    $this$any$iv = (Iterable)benchedMoves;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (BenchedMove)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getMoveTemplate(), (Object)moveToTeach)) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block20;
            }
            Object[] $i$f$any = new Object[]{translatedName, moveTranslated};
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_learnable.already_knows_move", $i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        if (cfg.getAnyMovesLearnableTMs() && !this.isTR || cfg.getAnyMovesLearnableTRs() && this.isTR) {
            return true;
        }
        if (SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING().contains(moveToTeach.getName())) {
            Object[] $i$f$any = new Object[]{translatedName, moveTranslated};
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_learnable.not_in_learnable_moves", $i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        if (MoveLearnItem.canPokemonLearnMove$canLearnFromLearnset(moveToTeach, cfg, pokemon.getForm().getMoves())) {
            return true;
        }
        Species species = pokemon.getSpecies();
        for (FormData form : species.getForms()) {
            if (Intrinsics.areEqual((Object)form, (Object)pokemon.getForm()) || !MoveLearnItem.canPokemonLearnMove$canLearnFromLearnset(moveToTeach, cfg, form.getMoves())) continue;
            return true;
        }
        if (cfg.getPrimaryTypeMovesLearnable() || cfg.getSecondaryTypeMovesLearnable()) {
            ElementalType primary = pokemon.getPrimaryType();
            ElementalType secondary = pokemon.getSecondaryType();
            if (cfg.getPrimaryTypeMovesLearnable() && Intrinsics.areEqual((Object)moveToTeach.getElementalType(), (Object)primary)) {
                return true;
            }
            if (cfg.getSecondaryTypeMovesLearnable() && Intrinsics.areEqual((Object)moveToTeach.getElementalType(), (Object)secondary)) {
                return true;
            }
        }
        Object[] objectArray = new Object[]{translatedName, moveTranslated};
        MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_learnable.not_in_learnable_moves", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
        FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
        return false;
    }

    private final boolean canPokemonLearnMove(Pokemon pokemon) {
        boolean isTR = this.isTR;
        if (!SimpleTMs.INSTANCE.getConfig().getTmsUsable() && !isTR) {
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_usable.tms_disabled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        if (!SimpleTMs.INSTANCE.getConfig().getTrsUsable() && isTR) {
            MutableComponent mutableComponent = MiscUtilsKt.fromLang("simpletms", "error.not_usable.trs_disabled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"fromLang(...)");
            FailureMessage.Companion.setFailureMessage((Component)mutableComponent);
            return false;
        }
        String moveName = this.moveName;
        MoveTemplate move = Moves.getByNameOrDummy((String)moveName);
        return this.canPokemonLearnMove(pokemon, move);
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)tooltipContext, (String)"tooltipContext");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Color baseGreyColor = Color.LIGHT_GRAY;
        String moveName = this.moveName;
        MoveTemplate move = Moves.getByNameOrDummy((String)moveName);
        MutableComponent moveTranslatedName = move.getDisplayName();
        ElementalType moveType = move.getElementalType();
        double moveAccuracy = move.getAccuracy();
        int movebasePP = move.getPp();
        int movemaxPP = move.getMaxPp();
        double movePower = move.getPower();
        double moveCritRatio = move.getCritRatio();
        DamageCategory moveDamageCategory = move.getDamageCategory();
        int moveColour = moveType.getHue();
        Pair powerRange = TuplesKt.to((Object)0.0, (Object)200.0);
        Pair accuracyRange = TuplesKt.to((Object)0.0, (Object)100.0);
        Pair critRange = TuplesKt.to((Object)1.0, (Object)4.0);
        Pair ppRange = TuplesKt.to((Object)0.0, (Object)48.0);
        Pair powerColors = TuplesKt.to((Object)Color.WHITE, (Object)Color.ORANGE);
        Pair accuracyColors = TuplesKt.to((Object)Color.RED, (Object)Color.GREEN);
        Pair ppColors = TuplesKt.to((Object)Color.WHITE, (Object)Color.ORANGE);
        Pair critColors = TuplesKt.to((Object)Color.WHITE, (Object)Color.ORANGE);
        double d = ((Number)powerRange.getFirst()).doubleValue();
        double d2 = ((Number)powerRange.getSecond()).doubleValue();
        Object object = powerColors.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
        Color color = (Color)object;
        Object object2 = powerColors.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-second>(...)");
        Color movePowerColor = MiscUtilsKt.interpolateColor(movePower, d, d2, color, (Color)object2);
        double d3 = ((Number)accuracyRange.getFirst()).doubleValue();
        double d4 = ((Number)accuracyRange.getSecond()).doubleValue();
        Object object3 = accuracyColors.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"<get-first>(...)");
        Color color2 = (Color)object3;
        Object object4 = accuracyColors.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"<get-second>(...)");
        Color moveAccuracyColor = MiscUtilsKt.interpolateColor(moveAccuracy, d3, d4, color2, (Color)object4);
        double d5 = movemaxPP;
        double d6 = ((Number)ppRange.getFirst()).doubleValue();
        double d7 = ((Number)ppRange.getSecond()).doubleValue();
        Object object5 = ppColors.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"<get-first>(...)");
        Color color3 = (Color)object5;
        Object object6 = ppColors.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"<get-second>(...)");
        Color movePPColor = MiscUtilsKt.interpolateColor(d5, d6, d7, color3, (Color)object6);
        double d8 = ((Number)critRange.getFirst()).doubleValue();
        double d9 = ((Number)critRange.getSecond()).doubleValue();
        Object object7 = critColors.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"<get-first>(...)");
        Color color4 = (Color)object7;
        Object object8 = critColors.getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"<get-second>(...)");
        Color moveCritColor = MiscUtilsKt.interpolateColor(moveCritRatio, d8, d9, color4, (Color)object8);
        if (!Screen.hasShiftDown()) {
            MutableComponent itemDescription = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.description_start", new Object[0]).withColor(baseGreyColor.getRGB()).append((Component)moveTranslatedName.withColor(moveColour)).append((Component)MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.description_end", new Object[0]).withColor(baseGreyColor.getRGB()));
            Intrinsics.checkNotNull((Object)itemDescription);
            list.add((Component)itemDescription);
            MutableComponent holdShiftText = MiscUtilsKt.fromLang("simpletms", "item.tooltip.move_learn_item.hold_start", new Object[0]).withColor(baseGreyColor.getRGB()).append((Component)MiscUtilsKt.fromLang("simpletms", "item.tooltip.move_learn_item.hold_shift", new Object[0]).withColor(Color.ORANGE.getRGB())).append((Component)MiscUtilsKt.fromLang("simpletms", "item.tooltip.move_learn_item.hold_shift_info", new Object[0]).withColor(baseGreyColor.getRGB()));
            Intrinsics.checkNotNull((Object)holdShiftText);
            list.add((Component)holdShiftText);
        }
        if (Screen.hasShiftDown()) {
            String rawDescription = move.getDescription().getString();
            int maxLineLength = 60;
            Intrinsics.checkNotNull((Object)rawDescription);
            String[] stringArray = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)rawDescription, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            StringBuilder currentLine = new StringBuilder();
            List wrappedLines = new ArrayList();
            for (String word : words) {
                StringBuilder stringBuilder;
                if (((CharSequence)currentLine).length() == 0) {
                    stringBuilder = currentLine.append(word);
                    continue;
                }
                if (currentLine.length() + 1 + word.length() <= maxLineLength) {
                    stringBuilder = currentLine.append(" ").append(word);
                    continue;
                }
                String string = currentLine.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                wrappedLines.add(string);
                currentLine.setLength(0);
                stringBuilder = currentLine.append(word);
            }
            if (((CharSequence)currentLine).length() > 0) {
                String string = currentLine.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                wrappedLines.add(string);
            }
            for (String line : wrappedLines) {
                MutableComponent mutableComponent = Component.literal((String)line).withColor(baseGreyColor.getRGB());
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withColor(...)");
                list.add((Component)mutableComponent);
            }
            MutableComponent moveTypeBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_type", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent moveTypeComponent = moveType.getDisplayName().withColor(moveColour);
            MutableComponent mutableComponent = moveTypeBase.append((Component)moveTypeComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
            list.add((Component)mutableComponent);
            Color physicalColour = Color.RED;
            Color specialColour = Color.YELLOW;
            Color statusColour = Color.GREEN;
            DamageCategory damageCategory = moveDamageCategory;
            Color moveCategoryColour = Intrinsics.areEqual((Object)damageCategory, (Object)DamageCategories.INSTANCE.getPHYSICAL()) ? physicalColour : (Intrinsics.areEqual((Object)damageCategory, (Object)DamageCategories.INSTANCE.getSPECIAL()) ? specialColour : (Intrinsics.areEqual((Object)damageCategory, (Object)DamageCategories.INSTANCE.getSTATUS()) ? statusColour : baseGreyColor));
            MutableComponent moveCategoryBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_category", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent moveCategoryComponent = moveDamageCategory.getDisplayName().copy().withColor(moveCategoryColour.getRGB());
            MutableComponent mutableComponent2 = moveCategoryBase.append((Component)moveCategoryComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"append(...)");
            list.add((Component)mutableComponent2);
            MutableComponent movePowerBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_power", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent movePowerComponent = TextKt.text((String)String.valueOf(movePower)).withColor(movePowerColor.getRGB());
            if (movePower == 0.0) {
                movePowerComponent = TextKt.text((String)"N/A").withColor(Color.BLUE.getRGB());
            }
            MutableComponent mutableComponent3 = movePowerBase.append((Component)movePowerComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"append(...)");
            list.add((Component)mutableComponent3);
            MutableComponent moveAccuracyBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_accuracy", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent moveAccuracyComponent = TextKt.text((String)String.valueOf(moveAccuracy)).withColor(moveAccuracyColor.getRGB());
            if (moveAccuracy == -1.0) {
                moveAccuracyComponent = TextKt.text((String)"N/A").withColor(Color.BLUE.getRGB());
            }
            MutableComponent mutableComponent4 = moveAccuracyBase.append((Component)moveAccuracyComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"append(...)");
            list.add((Component)mutableComponent4);
            MutableComponent movePPBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_pp", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent movePPComponent = TextKt.text((String)String.valueOf(movebasePP)).withColor(movePPColor.getRGB());
            MutableComponent movePPMax = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_pp_max", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent movePPMaxComponent = TextKt.text((String)String.valueOf(movemaxPP)).withColor(movePPColor.getRGB());
            MutableComponent mutableComponent5 = movePPBase.append((Component)movePPComponent).append((Component)movePPMax).append((Component)movePPMaxComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"append(...)");
            list.add((Component)mutableComponent5);
            MutableComponent moveCritBase = MiscUtilsKt.fromLang("simpletms", "item.move_learn_item.move_crit_ratio", new Object[0]).withColor(baseGreyColor.getRGB());
            MutableComponent moveCritComponent = TextKt.text((String)String.valueOf(moveCritRatio)).withColor(moveCritColor.getRGB());
            MutableComponent mutableComponent6 = moveCritBase.append((Component)moveCritComponent);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"append(...)");
            list.add((Component)mutableComponent6);
        }
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }

    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> use(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        return PokemonSelectingItemNonBattle.super.use(player, stack);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> interactGeneral(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        return PokemonSelectingItemNonBattle.super.interactGeneral(player, stack);
    }

    private static final boolean canPokemonLearnMove$canLearnFromLearnset(MoveTemplate $moveToTeach, SimpleTMsConfig cfg, Learnset learnset) {
        if (!LearnsetQuery.Companion.getANY().canLearn($moveToTeach, learnset)) {
            return false;
        }
        if (cfg.getTmMovesLearnable() && LearnsetQuery.Companion.getTM_MOVE().canLearn($moveToTeach, learnset)) {
            return true;
        }
        if (cfg.getTutorMovesLearnable() && LearnsetQuery.Companion.getTUTOR_MOVES().canLearn($moveToTeach, learnset)) {
            return true;
        }
        if (cfg.getEggMovesLearnable() && LearnsetQuery.Companion.getEGG_MOVE().canLearn($moveToTeach, learnset)) {
            return true;
        }
        if (cfg.getLevelMovesLearnable() && LearnsetQuery.Companion.getANY_LEVEL().canLearn($moveToTeach, learnset)) {
            return true;
        }
        if (cfg.getLegacyMovesLearnable() && LearnsetQuery.Companion.getLEGACY_MOVES().canLearn($moveToTeach, learnset)) {
            return true;
        }
        return cfg.getSpecialMovesLearnable() && LearnsetQuery.Companion.getSPECIAL_MOVES().canLearn($moveToTeach, learnset);
    }
}

