/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.block.entity;

import dev.architectury.registry.menu.MenuRegistry;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.block.entity.SimpleTMsBlockEntities;
import dragomordor.simpletms.item.custom.MoveLearnItem;
import dragomordor.simpletms.network.SimpleTMsNetwork;
import dragomordor.simpletms.ui.PokemonFilterData;
import dragomordor.simpletms.ui.TMMachineMenu;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001KB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0017J1\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0011\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0011\u00a2\u0006\u0004\b%\u0010$J\u0015\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\u00020\b2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u00100\u001a\u00020\b2\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101J!\u00104\u001a\u00020\b2\u0006\u0010/\u001a\u00020.2\n\b\u0002\u00103\u001a\u0004\u0018\u000102\u00a2\u0006\u0004\b4\u00105J\u001f\u0010:\u001a\u00020\b2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208H\u0014\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010<\u001a\u00020\b2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208H\u0014\u00a2\u0006\u0004\b<\u0010;J\u0017\u0010=\u001a\u0002062\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010A\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010?H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u000f\u0010C\u001a\u00020\bH\u0002\u00a2\u0006\u0004\bC\u0010\nR \u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020 0D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0016\u0010G\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0011\u0010J\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bI\u0010$\u00a8\u0006L"}, d2={"Ldragomordor/simpletms/block/entity/TMMachineBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "markCreativeDestruction", "()V", "", "wasCreativeDestruction", "()Z", "", "moveName", "isTR", "", "getMoveQuantity", "(Ljava/lang/String;Z)I", "getTMDamage", "(Ljava/lang/String;)I", "hasMove", "(Ljava/lang/String;Z)Z", "canAddMore", "amount", "damage", "addMove", "(Ljava/lang/String;ZII)I", "removeMove", "(Ljava/lang/String;ZI)I", "", "Ldragomordor/simpletms/block/entity/TMMachineBlockEntity$StoredMoveData;", "getStoredQuantities", "()Ljava/util/Map;", "getUniqueMoveCount", "()I", "getTotalItemCount", "Lnet/minecraft/world/item/ItemStack;", "stack", "tryInsert", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/Level;", "level", "dropContents", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "openMenu", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Ldragomordor/simpletms/ui/PokemonFilterData;", "pokemonFilter", "openMenuWithFilter", "(Lnet/minecraft/server/level/ServerPlayer;Ldragomordor/simpletms/ui/PokemonFilterData;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "syncToClients", "", "storedMoves", "Ljava/util/Map;", "creativeDestruction", "Z", "getMaxTRStackSize", "maxTRStackSize", "StoredMoveData", "common"})
@SourceDebugExtension(value={"SMAP\nTMMachineBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TMMachineBlockEntity.kt\ndragomordor/simpletms/block/entity/TMMachineBlockEntity\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n382#2,7:366\n205#3,4:373\n1#4:377\n*S KotlinDebug\n*F\n+ 1 TMMachineBlockEntity.kt\ndragomordor/simpletms/block/entity/TMMachineBlockEntity\n*L\n122#1:366,7\n178#1:373,4\n*E\n"})
public final class TMMachineBlockEntity
extends BlockEntity {
    @NotNull
    private final Map<String, StoredMoveData> storedMoves;
    private boolean creativeDestruction;

    public TMMachineBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)SimpleTMsBlockEntities.INSTANCE.getTM_MACHINE().get(), pos, state);
        this.storedMoves = new LinkedHashMap();
    }

    public final void markCreativeDestruction() {
        this.creativeDestruction = true;
    }

    public final boolean wasCreativeDestruction() {
        return this.creativeDestruction;
    }

    public final int getMaxTRStackSize() {
        return SimpleTMs.INSTANCE.getConfig().getTrStackSize();
    }

    public final int getMoveQuantity(@NotNull String moveName, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        StoredMoveData storedMoveData = this.storedMoves.get(moveName);
        if (storedMoveData == null) {
            return 0;
        }
        StoredMoveData data = storedMoveData;
        return isTR ? data.getTrCount() : data.getTmCount();
    }

    public final int getTMDamage(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        StoredMoveData storedMoveData = this.storedMoves.get(moveName);
        return storedMoveData != null ? storedMoveData.getTmDamage() : 0;
    }

    public final boolean hasMove(@NotNull String moveName, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        return this.getMoveQuantity(moveName, isTR) > 0;
    }

    public final boolean canAddMore(@NotNull String moveName, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        int current = this.getMoveQuantity(moveName, isTR);
        int max = isTR ? this.getMaxTRStackSize() : 1;
        return current < max;
    }

    /*
     * WARNING - void declaration
     */
    public final int addMove(@NotNull String moveName, boolean isTR, int amount, int damage) {
        int current;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        Map<String, StoredMoveData> map = this.storedMoves;
        String key$iv = moveName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            StoredMoveData answer$iv = new StoredMoveData(0, 0, 0, 7, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        StoredMoveData data = (StoredMoveData)object;
        int max = isTR ? this.getMaxTRStackSize() : 1;
        int canAdd = RangesKt.coerceAtLeast((int)(max - (current = isTR ? data.getTrCount() : data.getTmCount())), (int)0);
        int toAdd = RangesKt.coerceAtMost((int)amount, (int)canAdd);
        if (toAdd > 0) {
            if (isTR) {
                data.setTrCount(data.getTrCount() + toAdd);
            } else {
                data.setTmCount(data.getTmCount() + toAdd);
                data.setTmDamage(damage);
            }
            this.setChanged();
            this.syncToClients();
        }
        return toAdd;
    }

    public static /* synthetic */ int addMove$default(TMMachineBlockEntity tMMachineBlockEntity, String string, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 1;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return tMMachineBlockEntity.addMove(string, bl, n, n2);
    }

    public final int removeMove(@NotNull String moveName, boolean isTR, int amount) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        StoredMoveData storedMoveData = this.storedMoves.get(moveName);
        if (storedMoveData == null) {
            return 0;
        }
        StoredMoveData data = storedMoveData;
        int current = isTR ? data.getTrCount() : data.getTmCount();
        int toRemove = RangesKt.coerceAtMost((int)amount, (int)current);
        if (toRemove > 0) {
            if (isTR) {
                data.setTrCount(data.getTrCount() - toRemove);
            } else {
                data.setTmCount(data.getTmCount() - toRemove);
            }
            if (data.isEmpty()) {
                this.storedMoves.remove(moveName);
            }
            this.setChanged();
            this.syncToClients();
        }
        return toRemove;
    }

    public static /* synthetic */ int removeMove$default(TMMachineBlockEntity tMMachineBlockEntity, String string, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return tMMachineBlockEntity.removeMove(string, bl, n);
    }

    @NotNull
    public final Map<String, StoredMoveData> getStoredQuantities() {
        return MapsKt.toMap(this.storedMoves);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUniqueMoveCount() {
        int n;
        Map<String, StoredMoveData> $this$count$iv = this.storedMoves;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Iterator<Map.Entry<String, StoredMoveData>> iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, StoredMoveData> element$iv;
                Map.Entry<String, StoredMoveData> it = element$iv = iterator.next();
                boolean bl = false;
                if (!(!it.getValue().isEmpty())) continue;
                ++count$iv;
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalItemCount() {
        Iterable iterable = this.storedMoves.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            StoredMoveData storedMoveData = (StoredMoveData)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getTmCount() + it.getTrCount();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final ItemStack tryInsert(@NotNull ItemStack stack) {
        boolean isTR;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Item item = stack.getItem();
        if (!(item instanceof MoveLearnItem)) {
            return stack;
        }
        String moveName = ((MoveLearnItem)item).getMoveName$common();
        if (!this.canAddMore(moveName, isTR = ((MoveLearnItem)item).isTR$common())) {
            return stack;
        }
        int damage = !isTR ? stack.getDamageValue() : 0;
        int added = this.addMove(moveName, isTR, stack.getCount(), damage);
        if (added > 0) {
            ItemStack remaining = stack.copy();
            remaining.shrink(added);
            Intrinsics.checkNotNull((Object)remaining);
            return remaining;
        }
        return stack;
    }

    public final void dropContents(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (Map.Entry<String, StoredMoveData> entry : this.storedMoves.entrySet()) {
            String moveName = entry.getKey();
            StoredMoveData data = entry.getValue();
            if (data.getTmCount() > 0) {
                ItemStack tmStack = SimpleTMsItems.INSTANCE.getItemStackFromName("tm_" + moveName);
                tmStack.setCount(data.getTmCount());
                tmStack.setDamageValue(data.getTmDamage());
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)tmStack);
            }
            if (data.getTrCount() <= 0) continue;
            ItemStack trStack = SimpleTMsItems.INSTANCE.getItemStackFromName("tr_" + moveName);
            trStack.setCount(data.getTrCount());
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)trStack);
        }
        this.storedMoves.clear();
    }

    public final void openMenu(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PokemonFilterData pendingFilter = SimpleTMsNetwork.INSTANCE.consumePendingMachineFilter(uUID);
        this.openMenuWithFilter(player, pendingFilter);
    }

    public final void openMenuWithFilter(@NotNull ServerPlayer player, @Nullable PokemonFilterData pokemonFilter) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MenuProvider menuProvider2 = new MenuProvider(this){
            final /* synthetic */ TMMachineBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.simpletms.tm_machine");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return new TMMachineMenu(containerId, playerInventory, this.this$0, null, null, 24, null);
            }
        };
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)menuProvider2, arg_0 -> TMMachineBlockEntity.openMenuWithFilter$lambda$3(this, pokemonFilter, arg_0));
    }

    public static /* synthetic */ void openMenuWithFilter$default(TMMachineBlockEntity tMMachineBlockEntity, ServerPlayer serverPlayer, PokemonFilterData pokemonFilterData, int n, Object object) {
        if ((n & 2) != 0) {
            pokemonFilterData = null;
        }
        tMMachineBlockEntity.openMenuWithFilter(serverPlayer, pokemonFilterData);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        CompoundTag movesTag = new CompoundTag();
        for (Map.Entry<String, StoredMoveData> entry : this.storedMoves.entrySet()) {
            String moveName = entry.getKey();
            StoredMoveData data = entry.getValue();
            CompoundTag moveTag = new CompoundTag();
            moveTag.putInt("tm", data.getTmCount());
            moveTag.putInt("tr", data.getTrCount());
            moveTag.putInt("tmDamage", data.getTmDamage());
            movesTag.put(moveName, (Tag)moveTag);
        }
        tag.put("stored_moves", (Tag)movesTag);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.storedMoves.clear();
        if (tag.contains("stored_moves", 10)) {
            CompoundTag movesTag = tag.getCompound("stored_moves");
            for (String moveName : movesTag.getAllKeys()) {
                CompoundTag moveTag = movesTag.getCompound(moveName);
                int tmCount = moveTag.getInt("tm");
                int trCount = moveTag.getInt("tr");
                int tmDamage = moveTag.getInt("tmDamage");
                if (tmCount <= 0 && trCount <= 0) continue;
                this.storedMoves.put(moveName, new StoredMoveData(tmCount, trCount, tmDamage));
            }
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private final void syncToClients() {
        block1: {
            Level level = this.level;
            if (level == null) break block1;
            Level lvl = level;
            boolean bl = false;
            if (!lvl.isClientSide) {
                lvl.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                SimpleTMsNetwork.INSTANCE.syncMachineToViewers(this);
            }
        }
    }

    private static final void openMenuWithFilter$lambda$3(TMMachineBlockEntity this$0, PokemonFilterData $pokemonFilter, FriendlyByteBuf buf) {
        buf.writeBlockPos(this$0.worldPosition);
        buf.writeVarInt(this$0.storedMoves.size());
        for (Map.Entry<String, StoredMoveData> object : this$0.storedMoves.entrySet()) {
            String moveName = object.getKey();
            StoredMoveData data = object.getValue();
            buf.writeUtf(moveName);
            buf.writeVarInt(data.getTmCount());
            buf.writeVarInt(data.getTrCount());
            buf.writeVarInt(data.getTmDamage());
        }
        boolean hasFilter = $pokemonFilter != null;
        buf.writeBoolean(hasFilter);
        if (hasFilter && $pokemonFilter != null) {
            buf.writeUtf($pokemonFilter.getSpeciesId());
            buf.writeUtf($pokemonFilter.getFormName());
            buf.writeUtf($pokemonFilter.getDisplayName());
            buf.writeVarInt($pokemonFilter.getLearnableMoves().size());
            for (String moveName : $pokemonFilter.getLearnableMoves()) {
                buf.writeUtf(moveName);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0012\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u001b\u00a8\u0006 "}, d2={"Ldragomordor/simpletms/block/entity/TMMachineBlockEntity$StoredMoveData;", "", "", "tmCount", "trCount", "tmDamage", "<init>", "(III)V", "", "isEmpty", "()Z", "component1", "()I", "component2", "component3", "copy", "(III)Ldragomordor/simpletms/block/entity/TMMachineBlockEntity$StoredMoveData;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getTmCount", "setTmCount", "(I)V", "getTrCount", "setTrCount", "getTmDamage", "setTmDamage", "common"})
    public static final class StoredMoveData {
        private int tmCount;
        private int trCount;
        private int tmDamage;

        public StoredMoveData(int tmCount, int trCount, int tmDamage) {
            this.tmCount = tmCount;
            this.trCount = trCount;
            this.tmDamage = tmDamage;
        }

        public /* synthetic */ StoredMoveData(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getTmCount() {
            return this.tmCount;
        }

        public final void setTmCount(int n) {
            this.tmCount = n;
        }

        public final int getTrCount() {
            return this.trCount;
        }

        public final void setTrCount(int n) {
            this.trCount = n;
        }

        public final int getTmDamage() {
            return this.tmDamage;
        }

        public final void setTmDamage(int n) {
            this.tmDamage = n;
        }

        public final boolean isEmpty() {
            return this.tmCount <= 0 && this.trCount <= 0;
        }

        public final int component1() {
            return this.tmCount;
        }

        public final int component2() {
            return this.trCount;
        }

        public final int component3() {
            return this.tmDamage;
        }

        @NotNull
        public final StoredMoveData copy(int tmCount, int trCount, int tmDamage) {
            return new StoredMoveData(tmCount, trCount, tmDamage);
        }

        public static /* synthetic */ StoredMoveData copy$default(StoredMoveData storedMoveData, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = storedMoveData.tmCount;
            }
            if ((n4 & 2) != 0) {
                n2 = storedMoveData.trCount;
            }
            if ((n4 & 4) != 0) {
                n3 = storedMoveData.tmDamage;
            }
            return storedMoveData.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "StoredMoveData(tmCount=" + this.tmCount + ", trCount=" + this.trCount + ", tmDamage=" + this.tmDamage + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.tmCount);
            result = result * 31 + Integer.hashCode(this.trCount);
            result = result * 31 + Integer.hashCode(this.tmDamage);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoredMoveData)) {
                return false;
            }
            StoredMoveData storedMoveData = (StoredMoveData)other;
            if (this.tmCount != storedMoveData.tmCount) {
                return false;
            }
            if (this.trCount != storedMoveData.trCount) {
                return false;
            }
            return this.tmDamage == storedMoveData.tmDamage;
        }

        public StoredMoveData() {
            this(0, 0, 0, 7, null);
        }
    }
}

