/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.cobblemon_autobattle.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    public static final ClientConfig INSTANCE = new ClientConfig();
    public static final long MIN_SELECT_DELAY = 20L;
    public static final long MAX_SELECT_DELAY = 8000L;
    public static final long DEFAULT_SELECT_DELAY = 200L;
    public static final double DEFAULT_SWITCH_CHANCE = 0.1;
    private ModConfigSpec.ConfigValue<Boolean> autobattle_enabled;
    private ModConfigSpec.ConfigValue<Long> select_delay;
    private ModConfigSpec.ConfigValue<Double> switch_chance;
    private final ModConfigSpec spec;

    ClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.autobattle_enabled = builder.comment("#").comment("Toggle Autobattle.").define("autobattle_enabled", false);
        this.select_delay = builder.comment("#").comment("Delay in ms before making a choice.").defineInRange("select_delay", Math.min(8000L, 200L), 20L, 8000L);
        this.switch_chance = builder.comment("#").comment("Chance to randomly switch to another pokemon if possible.").defineInRange("switch_chance", 0.1, 0.0, 1.0);
        this.spec = builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    public boolean autobattle_enabled() {
        return (Boolean)this.autobattle_enabled.get();
    }

    public void autobattle_enabled(boolean value) {
        this.autobattle_enabled.set((Object)value);
    }

    public long select_delay() {
        return (Long)this.select_delay.get();
    }

    public void select_delay(long value) {
        this.select_delay.set((Object)value);
    }

    public double switch_chance() {
        return (Double)this.switch_chance.get();
    }

    public void switch_chance(double value) {
        this.switch_chance.set((Object)value);
    }
}

