/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.cobblemon_autobattle.client;

import com.gitlab.srcmc.cobblemon_autobattle.client.Messages;
import com.gitlab.srcmc.cobblemon_autobattle.config.ClientConfig;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.Lazy;

public class KeyBindings {
    private static final int INPUT_DELAY_TICKS = 20;
    private Map<InputType, MappingEntry> mappings = Map.ofEntries(Map.entry(InputType.TOGGLE_AUTOBATTLE_ENABLED, new MappingEntry(this, (Lazy<KeyMapping>)Lazy.lazy(() -> new KeyMapping(String.format("key.%s.autobattle_enabled", "cobblemon_autobattle"), InputConstants.Type.KEYSYM, 75, String.format("key.categories.%s", "cobblemon_autobattle"))), () -> {
        ClientConfig.INSTANCE.autobattle_enabled(!ClientConfig.INSTANCE.autobattle_enabled());
        Messages.minor((Component)Component.translatable((String)"chat.cobblemon_autobattle.autobattle").append((Component)Component.literal((String)" ")).append((Component)(ClientConfig.INSTANCE.autobattle_enabled() ? Component.translatable((String)"chat.cobblemon_autobattle.enabled").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD) : Component.translatable((String)"chat.cobblemon_autobattle.disabled").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD))));
    })));

    public Lazy<KeyMapping> get(InputType type) {
        return this.mappings.get((Object)((Object)type)).mapping;
    }

    public Collection<Lazy<KeyMapping>> getAll() {
        return this.mappings.values().stream().map(e -> e.mapping).toList();
    }

    public void tick(Minecraft mc) {
        this.mappings.values().forEach(e -> {
            if (e.delay == 0 || e.delay > 0 && --e.delay == 0) {
                boolean consumed;
                KeyMapping mapping = (KeyMapping)e.mapping.get();
                while (consumed = mapping.consumeClick()) {
                    e.handler.run();
                }
                if (consumed) {
                    e.delay = 20;
                }
            }
        });
    }

    public static enum InputType {
        TOGGLE_AUTOBATTLE_ENABLED;

    }

    class MappingEntry {
        public final Lazy<KeyMapping> mapping;
        public final Runnable handler;
        public boolean canHold;
        public int delay;

        public MappingEntry(KeyBindings this$0, Lazy<KeyMapping> mapping, Runnable handler) {
            this(this$0, mapping, handler, false);
        }

        public MappingEntry(KeyBindings this$0, Lazy<KeyMapping> mapping, Runnable handler, boolean canHold) {
            this.mapping = mapping;
            this.handler = handler;
            this.canHold = canHold;
        }
    }
}

