/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.mixin;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.styledplayerlist.PlayerList;
import eu.pb4.styledplayerlist.SPLHelper;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.config.Config;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.DefaultValues;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.scores.DisplaySlot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerPlayNetworkManagerMixin
extends ServerCommonPacketListenerImpl
implements PlayerListViewerHolder {
    @Shadow
    public ServerPlayer player;
    @Unique
    private String styledPlayerList$activeStyle = ConfigManager.getDefault();
    @Unique
    private PlayerListStyle styledPlayerList$style = DefaultValues.EMPTY_STYLE;
    @Unique
    private int styledPlayerList$animationTick = 0;
    @Unique
    private boolean styledPlayerList$hasRightText = false;

    public ServerPlayNetworkManagerMixin(MinecraftServer server, Connection connection, CommonListenerCookie clientData) {
        super(server, connection, clientData);
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="TAIL")})
    private void styledPlayerList$loadData(MinecraftServer server, Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        try {
            StringTag style = (StringTag)PlayerDataApi.getGlobalDataFor((ServerPlayer)player, (ResourceLocation)PlayerList.id("style"), (TagType)StringTag.TYPE);
            if (style != null) {
                this.styledPlayerList$setStyle(style.getAsString());
            } else {
                this.styledPlayerList$reloadStyle();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void styledPlayerList$updatePlayerList(CallbackInfo ci) {
        if (ConfigManager.isEnabled() && SPLHelper.shouldSendPlayerList(this.player)) {
            int tick = this.server.getTickCount();
            ConfigData config = ConfigManager.getConfig().configData;
            if (tick % this.styledPlayerList$style.updateRate == 0) {
                PlaceholderContext context = PlaceholderContext.of((ServerPlayer)this.player, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_LIST_VIEW);
                this.send((Packet)new ClientboundTabListPacket(this.styledPlayerList$style.getHeader(context, this.styledPlayerList$animationTick), this.styledPlayerList$style.getFooter(context, this.styledPlayerList$animationTick)));
                ++this.styledPlayerList$animationTick;
            }
            if (config.playerName.playerNameUpdateRate > 0L && (long)tick % config.playerName.playerNameUpdateRate == 0L) {
                this.styledPlayerList$updateName();
            }
        }
    }

    @Inject(method={"broadcastChatMessage(Lnet/minecraft/network/chat/PlayerChatMessage;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;detectRateSpam()V")})
    private void styledPlayerList$onMessage(PlayerChatMessage signedMessage, CallbackInfo ci) {
        if (ConfigManager.isEnabled() && ConfigManager.getConfig().configData.playerName.updatePlayerNameEveryChatMessage) {
            this.styledPlayerList$updateName();
        }
    }

    @Override
    public void styledPlayerList$setStyle(String key) {
        this.styledPlayerList$activeStyle = ConfigManager.isEnabled() ? (ConfigManager.styleExist(key) ? key : ConfigManager.getDefault()) : "default";
        this.styledPlayerList$reloadStyle();
        PlayerDataApi.setGlobalDataFor((ServerPlayer)this.player, (ResourceLocation)PlayerList.id("style"), (Tag)StringTag.valueOf((String)this.styledPlayerList$activeStyle));
    }

    @Override
    public String styledPlayerList$getStyle() {
        return this.styledPlayerList$activeStyle;
    }

    @Override
    public void styledPlayerList$updateName() {
        try {
            ClientboundPlayerInfoUpdatePacket packet;
            if (!ConfigManager.isEnabled()) {
                return;
            }
            if (ConfigManager.getConfig().configData.playerName.changePlayerName) {
                packet = new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED), List.of(this.player));
                this.server.getPlayerList().broadcastAll((Packet)packet);
            }
            if (ConfigManager.getConfig().configData.playerName.changeRightText) {
                packet = new ClientboundSetScorePacket(this.player.getScoreboardName(), "\u25a0SPL_OBJ", 0, Optional.empty(), Optional.of(new FixedFormat(ConfigManager.getConfig().formatPlayerRightText(this.player))));
                this.server.getPlayerList().broadcastAll((Packet)packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void styledPlayerList$setupRightText() {
        Config config = ConfigManager.getConfig();
        if (config.configData.playerName.changeRightText && !this.styledPlayerList$hasRightText) {
            this.styledPlayerList$hasRightText = true;
            this.send((Packet)new ClientboundSetObjectivePacket(PlayerList.SCOREBOARD_OBJECTIVE, 0));
            this.send((Packet)new ClientboundSetDisplayObjectivePacket(DisplaySlot.LIST, PlayerList.SCOREBOARD_OBJECTIVE));
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                ClientboundSetScorePacket packet = new ClientboundSetScorePacket(player.getScoreboardName(), "\u25a0SPL_OBJ", 0, Optional.empty(), Optional.of(new FixedFormat(ConfigManager.getConfig().formatPlayerRightText(player))));
                this.send((Packet)packet);
            }
        } else if (!config.configData.playerName.changeRightText && this.styledPlayerList$hasRightText) {
            this.styledPlayerList$hasRightText = false;
            this.send((Packet)new ClientboundSetDisplayObjectivePacket(DisplaySlot.LIST, null));
            this.send((Packet)new ClientboundSetObjectivePacket(PlayerList.SCOREBOARD_OBJECTIVE, 1));
        }
    }

    @Override
    public void styledPlayerList$reloadStyle() {
        PlayerListStyle style = ConfigManager.getStyle(this.styledPlayerList$activeStyle);
        if (style != this.styledPlayerList$style) {
            this.styledPlayerList$style = style;
            this.styledPlayerList$animationTick = 0;
        }
    }

    @Override
    public int styledPlayerList$getAndIncreaseAnimationTick() {
        return this.styledPlayerList$animationTick++;
    }

    @Override
    public PlayerListStyle styledPlayerList$getStyleObject() {
        return this.styledPlayerList$style;
    }
}

