/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.styledplayerlist.GenericModInfo;
import eu.pb4.styledplayerlist.Permissions;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public class Commands {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"styledplayerlist").requires(Permissions.require("styledplayerlist.main", true))).executes(Commands::about)).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"switch").requires(Permissions.require("styledplayerlist.switch", true))).then(Commands.switchArgument("style").executes(Commands::switchStyle)))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"switchothers").requires(Permissions.require("styledplayerlist.switch.others", 2))).then(net.minecraft.commands.Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.switchArgument("style").executes(Commands::switchStyleOthers))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"reload").requires(Permissions.require("styledplayerlist.reload", 3))).executes(Commands::reloadConfig)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"plstyle").requires(Permissions.require("styledplayerlist.switch", true))).then(Commands.switchArgument("style").executes(Commands::switchStyle)));
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        if (ConfigManager.loadConfig()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded config!"), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Error accrued while reloading config!").withStyle(ChatFormatting.RED));
        }
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
            ((PlayerListViewerHolder)player.connection).styledPlayerList$reloadStyle();
            ((PlayerListViewerHolder)player.connection).styledPlayerList$setupRightText();
        }
        return 1;
    }

    private static int about(CommandContext<CommandSourceStack> context) {
        for (Component text : ((CommandSourceStack)context.getSource()).getEntity() instanceof ServerPlayer ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
        }
        return 1;
    }

    public static int switchStyleOthers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String styleId = (String)context.getArgument("style", String.class);
        Collection target = EntityArgument.getPlayers(context, (String)"targets");
        if (!ConfigManager.styleExist(styleId)) {
            source.sendSuccess(() -> ConfigManager.getConfig().unknownStyleMessage, false);
            return 0;
        }
        PlayerListStyle style = ConfigManager.getStyle(styleId);
        for (ServerPlayer player : target) {
            ((PlayerListViewerHolder)player.connection).styledPlayerList$setStyle(styleId);
        }
        source.sendSuccess(() -> Component.literal((String)("Changed player list style of targets to " + style.name)), false);
        return 2;
    }

    private static int switchStyle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            String styleId = (String)context.getArgument("style", String.class);
            if (!ConfigManager.styleExist(styleId)) {
                source.sendSuccess(() -> ConfigManager.getConfig().unknownStyleMessage, false);
                return 0;
            }
            PlayerListStyle style = ConfigManager.getStyle(styleId);
            ServerPlayer player = source.getPlayer();
            if (player != null && player instanceof ServerPlayer) {
                if (style.hasPermission(player)) {
                    ((PlayerListViewerHolder)player.connection).styledPlayerList$setStyle(styleId);
                    source.sendSuccess(() -> ConfigManager.getConfig().getSwitchMessage(player, style.name), false);
                    return 1;
                }
                source.sendSuccess(() -> ConfigManager.getConfig().permissionMessage, false);
            } else {
                source.sendSuccess(() -> Component.literal((String)"Only players can use this command!"), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static RequiredArgumentBuilder<CommandSourceStack, String> switchArgument(String name) {
        return net.minecraft.commands.Commands.argument((String)name, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (PlayerListStyle style : ConfigManager.getStyles()) {
                if (!style.id.contains(remaining) || !style.hasPermission((CommandSourceStack)ctx.getSource())) continue;
                builder.suggest(style.id);
            }
            return builder.buildFuture();
        });
    }
}

