/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.styledplayerlist.GenericModInfo;
import eu.pb4.styledplayerlist.SPLHelper;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import java.util.LinkedHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="styledplayerlist")
@EventBusSubscriber
public class PlayerList {
    public static final Logger LOGGER = LogManager.getLogger((String)"Styled Player List");
    public static final String ID = "styledplayerlist";
    public static final Scoreboard SCOREBOARD = new Scoreboard();
    public static final String OBJECTIVE_NAME = "\u25a0SPL_OBJ";
    public static final Objective SCOREBOARD_OBJECTIVE = new Objective(SCOREBOARD, "\u25a0SPL_OBJ", ObjectiveCriteria.DUMMY, (Component)Component.empty(), ObjectiveCriteria.RenderType.INTEGER, false, null);

    public PlayerList(ModContainer container) {
        GenericModInfo.build(container);
        Placeholders.registerChangeEvent((a, b) -> ConfigManager.rebuildStyled());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ConfigManager.loadConfig();
    }

    private void tick(MinecraftServer server) {
        if (ConfigManager.isEnabled()) {
            ConfigData config = ConfigManager.getConfig().configData;
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                long x = System.nanoTime();
                if (!SPLHelper.shouldSendPlayerList(player) || player.connection == null) continue;
                int tick = server.getTickCount();
                PlayerListViewerHolder holder = (PlayerListViewerHolder)player.connection;
                PlayerListStyle style = holder.styledPlayerList$getStyleObject();
                if (tick % style.updateRate == 0) {
                    PlaceholderContext context = PlaceholderContext.of((ServerPlayer)player, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_LIST_VIEW);
                    int animationTick = holder.styledPlayerList$getAndIncreaseAnimationTick();
                    player.connection.send((Packet)new ClientboundTabListPacket(style.getHeader(context, animationTick), style.getFooter(context, animationTick)));
                }
                if (config.playerName.playerNameUpdateRate > 0L && (long)tick % config.playerName.playerNameUpdateRate == 0L) {
                    holder.styledPlayerList$updateName();
                }
                player.displayClientMessage((Component)Component.literal((String)(tick + " | " + (float)(System.nanoTime() - x) / 1000000.0f)), true);
            }
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static String getPlayersStyle(ServerPlayer player) {
        return ((PlayerListViewerHolder)player.connection).styledPlayerList$getStyle();
    }

    public static void setPlayersStyle(ServerPlayer player, String key) {
        ((PlayerListViewerHolder)player).styledPlayerList$setStyle(key);
    }

    public static void addUpdateSkipCheck(ModCompatibility check) {
        SPLHelper.COMPATIBILITY.add(check);
    }

    public static interface ModCompatibility {
        public boolean check(ServerPlayer var1);
    }

    public record StyleHelper(LinkedHashMap<String, PlayerListStyle> styles) {
        public void addStyle(PlayerListStyle style) {
            this.styles.put(style.id, style);
        }

        public void removeStyle(PlayerListStyle style) {
            this.styles.remove(style.id, style);
        }
    }

    @FunctionalInterface
    public static interface PlayerListStyleLoad {
        public void onPlayerListUpdate(StyleHelper var1);
    }
}

