/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.screen.slot;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LockPredicateSlot
extends Slot {
    Predicate<Integer> predicate;

    public LockPredicateSlot(Container inventory, int index, int x, int y, Predicate<Integer> predicate) {
        super(inventory, index, x, y);
        this.predicate = predicate;
    }

    public boolean mayPlace(ItemStack stack) {
        return !this.predicate.test(this.getContainerSlot()) && super.mayPlace(stack);
    }

    public ItemStack remove(int amount) {
        if (this.predicate.test(this.getContainerSlot())) {
            return ItemStack.EMPTY;
        }
        return super.remove(amount);
    }

    public ItemStack safeTake(int min, int max, Player player) {
        if (this.predicate.test(this.getContainerSlot())) {
            return ItemStack.EMPTY;
        }
        return super.safeTake(min, max, player);
    }

    public Optional<ItemStack> tryRemove(int min, int max, Player player) {
        if (this.predicate.test(this.getContainerSlot())) {
            return Optional.empty();
        }
        return super.tryRemove(min, max, player);
    }

    public ItemStack safeInsert(ItemStack stack, int count) {
        if (this.predicate.test(this.getContainerSlot())) {
            return ItemStack.EMPTY;
        }
        return super.safeInsert(stack, count);
    }

    public ItemStack safeInsert(ItemStack stack) {
        if (this.predicate.test(this.getContainerSlot())) {
            return ItemStack.EMPTY;
        }
        return super.safeInsert(stack);
    }

    public boolean allowModification(Player player) {
        if (this.predicate.test(this.getContainerSlot())) {
            return false;
        }
        return super.allowModification(player);
    }

    public boolean mayPickup(Player playerEntity) {
        if (this.predicate.test(this.getContainerSlot())) {
            return false;
        }
        return super.mayPickup(playerEntity);
    }
}

