/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.screen;

import java.util.function.Supplier;
import mod.linguardium.badgebox.common.registration.ModScreenHandlerTypes;
import mod.linguardium.badgebox.common.screen.slot.LockPredicateSlot;
import mod.linguardium.badgebox.common.screen.slot.TagLimitedSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BadgeBoxContainerScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    public static final int INVENTORY_COLUMNS = 4;
    public static final int INVENTORY_ROWS = 2;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;
    private final int playerInventoryRows = (36 - Inventory.getSelectionSize()) / 9;
    private final Inventory playerInventory;
    final int boxSlot;
    boolean hasRibbonSlot;

    public static int getInventorySlotCount() {
        return 8;
    }

    public BadgeBoxContainerScreenHandler(int syncId, Inventory playerInventory, Container inventory, boolean hasRibbonSlotStack, int boxSlot) {
        super((MenuType)ModScreenHandlerTypes.BADGE_BOX_SCREEN_HANDLER_TYPE.get(), syncId);
        this.inventory = inventory;
        this.playerInventory = playerInventory;
        this.boxSlot = boxSlot;
        this.hasRibbonSlot = hasRibbonSlotStack;
        this.addBadgeSlots();
        this.addPlayerHotbarSlots();
        this.addPlayerInventorySlots();
    }

    public static BadgeBoxContainerScreenHandler create(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        ExtendedScreenHandlerData data = (ExtendedScreenHandlerData)ExtendedScreenHandlerData.PACKET_CODEC.decode((Object)buf);
        return new BadgeBoxContainerScreenHandler(syncId, playerInventory, data);
    }

    public BadgeBoxContainerScreenHandler(int syncId, Inventory playerInventory, ExtendedScreenHandlerData data) {
        this(syncId, playerInventory, BadgeBoxContainerScreenHandler.createClientsideInventory(data), data.ribbon, data.boxSlot());
    }

    private static Container createClientsideInventory(ExtendedScreenHandlerData data) {
        int slots = 8;
        if (data.ribbon()) {
            ++slots;
        }
        return new SimpleContainer(slots);
    }

    private boolean isBoxSlot(Integer index) {
        return this.boxSlot == index;
    }

    private void addBadgeSlots() {
        int offset = 0;
        int ribbonOffsetX = 29;
        int ribbonOffsetY = 9;
        if (this.hasRibbonSlot()) {
            offset = -13;
        }
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.addSlot(TagLimitedSlot.badge(this.inventory, x + y * 4, offset + 57 + x * 18, 28 + y * 18));
            }
        }
        if (this.hasRibbonSlot()) {
            this.addSlot(TagLimitedSlot.ribbon(this.inventory, this.inventory.getContainerSize() - 1, ribbonOffsetX + 93, ribbonOffsetY + 28));
        }
    }

    private void addPlayerInventorySlots() {
        int hotbarSize = Inventory.getSelectionSize();
        for (int y = 0; y < this.playerInventoryRows; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new LockPredicateSlot((Container)this.playerInventory, hotbarSize + x + y * 9, 12 + x * 18, 84 + y * 18, this::isBoxSlot));
            }
        }
    }

    private void addPlayerHotbarSlots() {
        for (int x = 0; x < Inventory.getSelectionSize(); ++x) {
            this.addSlot(new LockPredicateSlot((Container)this.playerInventory, x, 12 + x * 18, 142, this::isBoxSlot));
        }
    }

    private int getInventorySlots() {
        return this.inventory.getContainerSize();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return super.canTakeItemForPickAll(stack, slot) && slot.mayPlace(stack);
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private boolean isBadgeSlot(int slotIndex) {
        return slotIndex < this.getInventorySlots();
    }

    private boolean isHotbarSlot(int slotIndex) {
        int playerSlot = this.getPlayerSlotInventoryIndex(slotIndex);
        return Inventory.isHotbarSlot((int)playerSlot);
    }

    private Tuple<Integer, Integer> getPlayerMainSlotRange() {
        int start = this.getInventorySlots() + Inventory.getSelectionSize();
        int end = this.slots.size();
        return new Tuple((Object)start, (Object)end);
    }

    private Tuple<Integer, Integer> getPlayerHotbarSlotRange() {
        int start = this.getInventorySlots();
        int end = start + Inventory.getSelectionSize();
        return new Tuple((Object)start, (Object)end);
    }

    private Tuple<Integer, Integer> getInventorySlotRange() {
        return new Tuple((Object)0, (Object)this.getInventorySlots());
    }

    private boolean insertIntoBadgeSlots(ItemStack stack) {
        return this.insertIntoRange(stack, this::getInventorySlotRange);
    }

    private boolean insertIntoPlayerSlots(ItemStack stack) {
        return this.insertIntoRange(stack, this::getPlayerMainSlotRange);
    }

    private boolean insertIntoHotbarSlots(ItemStack stack) {
        return this.insertIntoRange(stack, this::getPlayerHotbarSlotRange);
    }

    private boolean insertIntoRange(ItemStack stack, Supplier<Tuple<Integer, Integer>> rangeProvider) {
        Tuple<Integer, Integer> range = rangeProvider.get();
        return this.moveItemStackTo(stack, (Integer)range.getA(), (Integer)range.getB(), false);
    }

    private boolean isValidScreenSlot(int slotIndex) {
        return slotIndex < this.slots.size() && slotIndex >= 0;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        if (!this.isValidSlotIndex(slotIndex)) {
            return ItemStack.EMPTY;
        }
        if (!this.isValidScreenSlot(slotIndex)) {
            return ItemStack.EMPTY;
        }
        Slot moveSlot = (Slot)this.slots.get(slotIndex);
        if (!moveSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack moveStack = moveSlot.getItem();
        ItemStack returnStack = moveStack.copy();
        if (this.isBadgeSlot(slotIndex) ? !this.insertIntoHotbarSlots(moveStack) && !this.insertIntoPlayerSlots(moveStack) : (this.isHotbarSlot(slotIndex) ? !this.insertIntoBadgeSlots(moveStack) && !this.insertIntoPlayerSlots(moveStack) : !this.insertIntoBadgeSlots(moveStack) && !this.insertIntoHotbarSlots(moveStack))) {
            return ItemStack.EMPTY;
        }
        if (moveStack.isEmpty()) {
            moveSlot.setByPlayer(ItemStack.EMPTY);
        } else {
            moveSlot.setChanged();
        }
        return returnStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public Container getInventory() {
        return this.inventory;
    }

    public boolean hasRibbonSlot() {
        return this.hasRibbonSlot;
    }

    private int getPlayerSlotInventoryIndex(int slotIndex) {
        int newIdx = slotIndex - this.getInventorySlots();
        if (newIdx < 0) {
            newIdx = -1;
        }
        return newIdx;
    }

    public record ExtendedScreenHandlerData(boolean ribbon, int boxSlot) {
        public static final StreamCodec<FriendlyByteBuf, ExtendedScreenHandlerData> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ExtendedScreenHandlerData::ribbon, (StreamCodec)ByteBufCodecs.INT, ExtendedScreenHandlerData::boxSlot, ExtendedScreenHandlerData::new);
    }
}

