/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.registration;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mod.linguardium.badgebox.common.Util;
import mod.linguardium.badgebox.common.item.BadgeBoxItem;
import mod.linguardium.badgebox.common.item.BadgeItem;
import mod.linguardium.badgebox.common.item.RibbonItem;
import mod.linguardium.badgebox.common.item.components.BadgeInventoryComponent;
import mod.linguardium.badgebox.common.registration.BadgeBoxRegistrar;
import mod.linguardium.badgebox.common.registration.ModDataComponentType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class ModItems {
    public static final RegistrySupplier<Item> BADGE_BOX_ITEM = ModItems.register("badgesbox", settings -> new BadgeBoxItem(settings.stacksTo(1).component((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)BadgeInventoryComponent.EMPTY)));
    public static final RegistrySupplier<Item> BADGE_BOX_ITEM_RIBBON = ModItems.register("badgesbox_ribbon", settings -> new BadgeBoxItem(settings.stacksTo(1).rarity(Rarity.UNCOMMON).component((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)BadgeInventoryComponent.EMPTY.setRibbonSlot(Optional.of(ItemStack.EMPTY)))));

    public static void init() {
        LifecycleEvent.SETUP.register(() -> {});
        List.of("fairy", "ghost", "grass", "ice", "mountain", "poison", "steel", "thunder", "wave", "wyvern", "bug", "dark", "fire", "flying", "normal", "psychic", "rock", "fighting").forEach(name -> ModItems.createBadge(name + "_badge"));
        List.of("master").forEach(name -> ModItems.createRibbon(name + "_ribbon"));
    }

    private static RegistrySupplier<Item> register(String name, Function<Item.Properties, Item> factory) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Util.id(name));
        return BadgeBoxRegistrar.ITEMS.register(key.location(), () -> (Item)factory.apply(new Item.Properties()));
    }

    private static RegistrySupplier<Item> createBadge(String name) {
        return ModItems.register(name, settings -> new BadgeItem(settings.rarity(Rarity.EPIC).stacksTo(1)));
    }

    private static RegistrySupplier<Item> createRibbon(String name) {
        return ModItems.register(name, settings -> new RibbonItem(settings.rarity(Rarity.EPIC).stacksTo(1)));
    }
}

