/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.recipe;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mod.linguardium.badgebox.common.item.components.BadgeInventoryComponent;
import mod.linguardium.badgebox.common.mixin.ShapedRecipeAccessor;
import mod.linguardium.badgebox.common.registration.ModDataComponentType;
import mod.linguardium.badgebox.common.registration.ModRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class AddRibbonRecipe
extends ShapedRecipe {
    public AddRibbonRecipe(ShapedRecipeAccessor recipe) {
        this(recipe.getGroup(), recipe.getCategory(), recipe.getPattern(), recipe.getResult(), recipe.getShowNotification());
    }

    public static AddRibbonRecipe create(ShapedRecipe recipe) {
        return new AddRibbonRecipe((ShapedRecipeAccessor)recipe);
    }

    public AddRibbonRecipe(String group, CraftingBookCategory category, ShapedRecipePattern raw, ItemStack result) {
        super(group, category, raw, result);
    }

    public AddRibbonRecipe(String group, CraftingBookCategory category, ShapedRecipePattern raw, ItemStack result, boolean showNotification) {
        super(group, category, raw, result, showNotification);
    }

    public ItemStack assemble(CraftingInput craftingRecipeInput, HolderLookup.Provider wrapperLookup) {
        ItemStack result = this.getResultItem(wrapperLookup).copy();
        craftingRecipeInput.items().stream().filter(inputStacks -> inputStacks.get((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get()) != null).findFirst().ifPresent(old -> {
            BadgeInventoryComponent existingComponent = (BadgeInventoryComponent)old.getOrDefault((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)BadgeInventoryComponent.EMPTY);
            BadgeInventoryComponent newComponent = (BadgeInventoryComponent)result.getOrDefault((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)BadgeInventoryComponent.EMPTY);
            newComponent = newComponent.setInventory(existingComponent.getItemStackList());
            if (existingComponent.hasRibbonSlot()) {
                newComponent.setRibbonSlot(Optional.of(existingComponent.getRibbonSlot()));
            }
            result.set((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)newComponent);
            old.set((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)BadgeInventoryComponent.EMPTY);
        });
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ADD_RIBBON_RECIPE_SERIALIZER.get();
    }

    public static class AddRibbonSerializer
    implements RecipeSerializer<AddRibbonRecipe> {
        public StreamCodec<RegistryFriendlyByteBuf, AddRibbonRecipe> streamCodec() {
            return RecipeSerializer.SHAPED_RECIPE.streamCodec().map(shaped -> new AddRibbonRecipe((ShapedRecipeAccessor)shaped), addon -> addon);
        }

        public MapCodec<AddRibbonRecipe> codec() {
            return RecipeSerializer.SHAPED_RECIPE.codec().xmap(shapedRecipe -> new AddRibbonRecipe((ShapedRecipeAccessor)shapedRecipe), ribbonRecipe -> ribbonRecipe);
        }
    }
}

