/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.item.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.linguardium.badgebox.common.item.ComponentStorageInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class BadgeInventoryComponent {
    public static final BadgeInventoryComponent EMPTY = new BadgeInventoryComponent((ImmutableList<ItemStack>)ImmutableList.copyOf((Collection)NonNullList.withSize((int)8, (Object)ItemStack.EMPTY)), Optional.empty());
    public static final MapCodec<BadgeInventoryComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("Size").forGetter(BadgeInventoryComponent::getSize), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ItemStack.CODEC).fieldOf("Items").forGetter(BadgeInventoryComponent::getNonEmptySlotMap), (App)Codec.BOOL.fieldOf("RibbonSlotEnabled").forGetter(BadgeInventoryComponent::hasRibbonSlot), (App)ItemStack.CODEC.optionalFieldOf("RibbonSlot", (Object)ItemStack.EMPTY).forGetter(BadgeInventoryComponent::getRibbonSlot)).apply((Applicative)instance, BadgeInventoryComponent::decode));
    public static final StreamCodec<RegistryFriendlyByteBuf, BadgeInventoryComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, BadgeInventoryComponent::getSize, (StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ItemStack.STREAM_CODEC), BadgeInventoryComponent::getNonEmptySlotMap, (StreamCodec)ByteBufCodecs.BOOL, BadgeInventoryComponent::hasRibbonSlot, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BadgeInventoryComponent::getRibbonSlot, BadgeInventoryComponent::decode);
    ImmutableList<ItemStack> badgeInventory;
    Optional<ItemStack> ribbonSlot;
    int hashCode = 0;

    private BadgeInventoryComponent(ImmutableList<ItemStack> badgeInventory, Optional<ItemStack> ribbonSlot) {
        this.badgeInventory = badgeInventory;
        this.ribbonSlot = ribbonSlot;
        this.hashCode = this.hashCode();
    }

    public ComponentStorageInventory asInventory(ItemStack stack) {
        return ComponentStorageInventory.fromBadgeInventoryComponent(stack, this);
    }

    public ImmutableList<ItemStack> getItemStackList() {
        return this.badgeInventory;
    }

    public ItemStack get(int slot) {
        if (slot < this.badgeInventory.size() && slot >= 0) {
            return (ItemStack)this.badgeInventory.get(slot);
        }
        return ItemStack.EMPTY;
    }

    public BadgeInventoryComponent setInventory(ImmutableList<ItemStack> newStackList) {
        NonNullList newItemList = NonNullList.withSize((int)Math.max(newStackList.size(), this.badgeInventory.size()), (Object)ItemStack.EMPTY);
        for (int i = 0; i < newStackList.size(); ++i) {
            newItemList.set(i, (Object)((ItemStack)newStackList.get(i)).copy());
        }
        return new BadgeInventoryComponent((ImmutableList<ItemStack>)ImmutableList.copyOf((Collection)newItemList), this.ribbonSlot);
    }

    public BadgeInventoryComponent setRibbonSlot(Optional<ItemStack> newRibbonSlot) {
        return new BadgeInventoryComponent(this.badgeInventory, newRibbonSlot);
    }

    public int getSize() {
        return this.badgeInventory.size();
    }

    public boolean hasRibbonSlot() {
        return this.ribbonSlot.isPresent();
    }

    public ItemStack getRibbonSlot() {
        return this.ribbonSlot.orElse(ItemStack.EMPTY);
    }

    private Map<String, ItemStack> getNonEmptySlotMap() {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        for (int idx = 0; idx < this.badgeInventory.size(); ++idx) {
            ItemStack stack = (ItemStack)this.badgeInventory.get(idx);
            if (stack.isEmpty()) continue;
            map.put(String.valueOf(idx), stack);
        }
        return map;
    }

    public int hashCode() {
        int hashcode = ItemStack.hashStackList(this.badgeInventory);
        return this.ribbonSlot.map(Object::hashCode).map(hash -> hashcode * 31 + hash).orElse(hashcode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BadgeInventoryComponent) {
            BadgeInventoryComponent badgeInventoryComponent = (BadgeInventoryComponent)o;
            return badgeInventoryComponent.hashCode == this.hashCode;
        }
        return false;
    }

    private static BadgeInventoryComponent decode(int size, Map<String, ItemStack> nonEmptySlotMap, Boolean ribbonSlotEnabled, ItemStack ribbonSlot) {
        NonNullList newItemList = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        nonEmptySlotMap.forEach((key, value) -> newItemList.set(Integer.parseInt(key), value));
        Optional<ItemStack> optionalRibbonSlot = Optional.empty();
        if (ribbonSlotEnabled.booleanValue()) {
            optionalRibbonSlot = Optional.of(ribbonSlot);
        }
        return new BadgeInventoryComponent((ImmutableList<ItemStack>)ImmutableList.copyOf((Collection)newItemList), optionalRibbonSlot);
    }
}

