/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import mod.linguardium.badgebox.common.item.components.BadgeInventoryComponent;
import mod.linguardium.badgebox.common.registration.ModDataComponentType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ComponentStorageInventory
extends SimpleContainer {
    ItemStack holder;
    boolean hasRibbonSlot = false;
    int listSize;
    BadgeInventoryComponent backingComponent;

    private ComponentStorageInventory(ItemStack holder, int size, @NotNull BadgeInventoryComponent backingComponent) {
        super(size);
        this.holder = holder;
        this.backingComponent = backingComponent;
        this.listSize = this.backingComponent.getSize();
        for (int idx = 0; idx < this.listSize; ++idx) {
            this.getItems().set(idx, (Object)this.backingComponent.get(idx));
        }
        this.hasRibbonSlot = this.backingComponent.hasRibbonSlot();
        if (this.backingComponent.hasRibbonSlot()) {
            this.getItems().set(this.listSize, (Object)this.backingComponent.getRibbonSlot());
        }
    }

    public static ComponentStorageInventory fromBadgeInventoryComponent(ItemStack holder, @NotNull BadgeInventoryComponent backingComponent) {
        int size = backingComponent.getSize();
        if (backingComponent.hasRibbonSlot()) {
            ++size;
        }
        return new ComponentStorageInventory(holder, size, backingComponent);
    }

    public void saveInventory() {
        BadgeInventoryComponent component = this.backingComponent.setInventory((ImmutableList<ItemStack>)ImmutableList.copyOf((Collection)this.getItems()).subList(0, this.listSize));
        if (this.hasRibbonSlot) {
            component = component.setRibbonSlot(Optional.of((ItemStack)this.getItems().get(this.listSize)));
        }
        this.updateBackingStackComponent(component);
    }

    public void updateBackingStackComponent(BadgeInventoryComponent component) {
        this.holder.set((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)component);
        this.backingComponent = component;
    }

    public void setChanged() {
        super.setChanged();
        this.saveInventory();
    }

    public void stopOpen(Player player) {
        super.stopOpen(player);
        this.saveInventory();
    }
}

