/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.item;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import mod.linguardium.badgebox.common.item.ComponentStorageInventory;
import mod.linguardium.badgebox.common.item.components.BadgeInventoryComponent;
import mod.linguardium.badgebox.common.registration.ModDataComponentType;
import mod.linguardium.badgebox.common.screen.BadgeBoxContainerScreenHandler;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BadgeBoxItem
extends Item {
    public BadgeBoxItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        final ItemStack stack = user.getItemInHand(hand);
        final BadgeInventoryComponent component = (BadgeInventoryComponent)stack.get((DataComponentType)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get());
        if (component == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        final int slot = user.getInventory().selected;
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayerEntity, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf buf) {
                    BadgeBoxContainerScreenHandler.ExtendedScreenHandlerData.PACKET_CODEC.encode((Object)buf, (Object)new BadgeBoxContainerScreenHandler.ExtendedScreenHandlerData(component.hasRibbonSlot(), slot));
                }

                public Component getDisplayName() {
                    return (Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"gui.badgebox.badge_box_gui.label"));
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
                    ComponentStorageInventory badgeInventory = component.asInventory(stack);
                    return new BadgeBoxContainerScreenHandler(syncId, playerInventory, (Container)badgeInventory, component.hasRibbonSlot(), slot);
                }
            });
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

