/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.client.screen;

import mod.linguardium.badgebox.common.screen.BadgeBoxContainerScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BadgeBoxContainerScreen
extends AbstractContainerScreen<BadgeBoxContainerScreenHandler> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"badgebox", (String)"textures/screens/badges_cobble_1.png");
    public static final ResourceLocation BACKGROUND_WITH_RIBBON_SLOT = ResourceLocation.fromNamespaceAndPath((String)"badgebox", (String)"textures/screens/badges_cobble_2.png");
    public static final int BACKGROUND_WIDTH = 184;
    public static final int BACKGROUND_HEIGHT = 161;

    public BadgeBoxContainerScreen(BadgeBoxContainerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 184;
        this.imageHeight = 161;
        this.height = 167;
        this.width = 184;
        this.titleLabelY = 12;
        this.titleLabelX = 10;
        this.inventoryLabelX = 12;
        this.inventoryLabelY = this.imageHeight - 90;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        context.blit(this.getBackgroundTexture(), left, top + 5, 0.0f, 0.0f, 184, 161, 184, 161);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -1, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -1, false);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    private ResourceLocation getBackgroundTexture() {
        if (((BadgeBoxContainerScreenHandler)this.getMenu()).hasRibbonSlot()) {
            return BACKGROUND_WITH_RIBBON_SLOT;
        }
        return BACKGROUND;
    }
}

