/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.util.Text;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class TrainerPlayer
implements Trainer {
    private ServerPlayer player;
    private Text playerName;

    public TrainerPlayer(@NotNull ServerPlayer player) {
        this.player = player;
        this.playerName = Text.literal(player.getDisplayName().getString());
    }

    @NotNull
    public ServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public Text getName() {
        return this.playerName;
    }

    @Override
    @NotNull
    public Pokemon[] getTeam() {
        ArrayList party = new ArrayList();
        Cobblemon.INSTANCE.getStorage().getParty(this.player).forEach(party::add);
        return party.toArray(new Pokemon[party.size()]);
    }

    @Override
    @NotNull
    public LivingEntity getEntity() {
        return this.getPlayer();
    }
}

