/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.pokemon.OriginalTrainerType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.gitlab.srcmc.rctapi.api.models.Gimmicks;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerBag;
import com.gitlab.srcmc.rctapi.api.util.Text;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TrainerNPC
implements Trainer {
    public static final String DUMMY_TAG = "rctapi:dummy";
    private Text name;
    private Text entityName;
    private Pokemon[] team;
    private GimmicksMap gimmicks;
    private TrainerBag bag;
    private BattleAI battleAI;
    private LivingEntity entity;
    private static LivingEntity dummyEntity;

    public TrainerNPC(@NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull LivingEntity entity) {
        this(Text.empty(), team, bag, battleAI, entity);
    }

    public TrainerNPC(@NotNull String name, @NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull LivingEntity entity) {
        this(Text.literal(name), team, bag, battleAI, entity);
    }

    public TrainerNPC(@NotNull Text name, @NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull LivingEntity entity) {
        this(name, team, new GimmicksMap(), bag, battleAI, entity);
    }

    public TrainerNPC(@NotNull Text name, @NotNull Pokemon[] team, @NotNull GimmicksMap gimmicks, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull LivingEntity entity) {
        this.name = name;
        this.team = team;
        this.gimmicks = gimmicks;
        this.bag = bag;
        this.battleAI = battleAI;
        this.setEntity(entity);
    }

    public TrainerNPC(@NotNull TrainerNPC other) {
        this.name = other.name;
        this.team = TrainerNPC.copyTeam(other.team);
        this.bag = other.bag;
        this.battleAI = other.battleAI;
        this.gimmicks = new GimmicksMap(other.gimmicks);
        this.setEntity(other.entity);
    }

    public void setEntity(@NotNull LivingEntity entity) {
        this.entity = entity;
        this.entityName = Text.literal(entity.getDisplayName().getString());
    }

    @NotNull
    public BattleAI getBattleAI() {
        return this.battleAI;
    }

    @NotNull
    public TrainerBag getBag() {
        return this.bag;
    }

    @NotNull
    public GimmicksMap getGimmicks() {
        return this.gimmicks;
    }

    @Override
    @NotNull
    public Text getName() {
        return this.name.getComponent(new Object[0]).getString().isEmpty() && this.getEntity().getDisplayName() != null ? this.entityName : this.name;
    }

    @Override
    @NotNull
    public Pokemon[] getTeam() {
        return this.team;
    }

    @Override
    @NotNull
    public LivingEntity getEntity() {
        return this.entity;
    }

    void initTeam(String otId) {
        for (Pokemon pkmn : this.team) {
            pkmn.setOriginalTrainer(otId);
            pkmn.setOriginalTrainerName(this.getName().getComponent(new Object[0]).getString());
            pkmn.setOriginalTrainerType$common(OriginalTrainerType.NPC);
            pkmn.getCustomProperties().add(UncatchableProperty.INSTANCE.uncatchable());
        }
    }

    private static Pokemon[] copyTeam(Pokemon[] team) {
        Pokemon[] copy = new Pokemon[team.length];
        for (int i = 0; i < team.length; ++i) {
            copy[i] = new Pokemon();
            copy[i].copyFrom(team[i]);
        }
        return copy;
    }

    public static LivingEntity getDummyEntity(MinecraftServer server) {
        if (dummyEntity == null || dummyEntity.getServer() != server || !dummyEntity.isAlive()) {
            if (dummyEntity != null) {
                dummyEntity.discard();
            }
            Villager dummy = (Villager)EntityType.VILLAGER.create((Level)server.overworld());
            dummy = (Villager)EntityType.VILLAGER.create((Level)server.overworld());
            dummy.addTag(DUMMY_TAG);
            dummy.setNoGravity(true);
            dummy.setInvulnerable(true);
            dummy.setInvisible(true);
            dummy.setNoAi(true);
            dummy.noPhysics = true;
            dummy.setPos(0.0, 1.073741823E9, 0.0);
            dummyEntity = dummy;
        }
        return dummyEntity;
    }

    public static class GimmicksMap {
        private Map<UUID, Gimmicks> map;

        public GimmicksMap() {
            this.map = new HashMap<UUID, Gimmicks>();
        }

        public GimmicksMap(GimmicksMap other) {
            this.map = new HashMap<UUID, Gimmicks>(other.map);
        }

        public Pokemon to(Pokemon p, Gimmicks g) {
            this.map.put(p.getUuid(), g);
            return p;
        }

        public Gimmicks of(Pokemon p) {
            return this.map.computeIfAbsent(p.getUuid(), k -> new Gimmicks());
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof GimmicksMap)) return false;
            GimmicksMap other = (GimmicksMap)obj;
            if (!this.map.equals(other.map)) return false;
            return true;
        }
    }
}

