/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.models.converter;

import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.errors.RCTError;
import com.gitlab.srcmc.rctapi.api.errors.RCTErrors;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.models.PokemonModel;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.models.converter.Converter;
import com.gitlab.srcmc.rctapi.api.models.converter.PokemonModelConverter;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerBag;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.util.Locations;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TrainerModelConverter
implements Converter<TrainerModel, TrainerNPC> {
    private final MinecraftServer server;
    private final PokemonModelConverter pmc;

    public TrainerModelConverter(@NotNull MinecraftServer server, @NotNull PokemonModelConverter pmc) {
        this.server = server;
        this.pmc = pmc;
    }

    @Override
    public TrainerNPC toTarget(@NotNull TrainerModel model, @NotNull RCTErrors<RCTException> errors) {
        if (model.getTeam().size() > 6) {
            errors.add(RCTError.of("too many pokemon in party " + model.getTeam().size() + "/6"));
        }
        BattleAI battleAI = model.getAI().get();
        TrainerNPC.GimmicksMap gimmicks = new TrainerNPC.GimmicksMap();
        if (battleAI == null) {
            errors.add(RCTError.of("unknown AI type"));
            battleAI = new RandomBattleAI();
        }
        Pokemon[] team = model.getTeam().stream().limit(6L).map(pkModel -> gimmicks.to(this.pmc.toTarget((PokemonModel)pkModel, errors), pkModel.getGimmicks())).toList().toArray(new Pokemon[0]);
        TrainerBag bag = new TrainerBag();
        model.getBag().forEach(bim -> {
            try {
                bag.add(Locations.withNamespace("cobblemon", bim.getItem()), bim.getQuantity());
            }
            catch (IllegalArgumentException e) {
                errors.add(RCTError.of(e));
            }
        });
        return new TrainerNPC(model.getName(), team, gimmicks, bag, battleAI, TrainerNPC.getDummyEntity(this.server));
    }
}

