/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.interactive.PotionType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.ai.config.RCTBattleAIConfig;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.Debug;
import com.gitlab.srcmc.rctapi.api.ai.utils.MoveType;
import com.gitlab.srcmc.rctapi.api.ai.utils.PokeMath;
import com.gitlab.srcmc.rctapi.api.ai.utils.ResponseBuilder;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import com.gitlab.srcmc.rctapi.api.models.Gimmicks;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.util.collection.WeightedCollection;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class RCTBattleAI
implements BattleAI {
    private double moveBias;
    private double statusMoveBias;
    private double switchBias;
    private double itemBias;
    private double maxSelectMargin;
    private Random rng = new Random();
    private static final int STATUS_WEIGHT = 8;
    private static final int BOOSTS_WEIGHT = 6;
    private static final int STATS_WEIGHT = 12;
    private static final int TYPING_WEIGHT = 48;
    private static final int LEVEL_WEIGHT = 12;
    private static final int HEALTH_WEIGHT = 6;
    private static final double STATUS_FACTOR = 0.5;
    private static final double BOOSTS_FACTOR = 0.5;
    private static final double HEALTH_FACTOR = 0.33;
    private static final double LEVEL_FACTOR = 0.33;
    private static final double DMAX_FACTOR = 0.25;
    private static final double MAX_TYPE_EFFECTIVENESS = 2.0;
    private static final double DEFAULT_SIG3 = 0.125;
    private static final double RATING_EXP = 1.25;

    public RCTBattleAI() {
        this(new RCTBattleAIConfig.Builder().build());
    }

    public RCTBattleAI(@NotNull RCTBattleAIConfig config) {
        this.moveBias = config.moveBias();
        this.statusMoveBias = config.statusMoveBias();
        this.switchBias = config.switchBias();
        this.itemBias = config.itemBias();
        this.maxSelectMargin = config.maxSelectMargin();
    }

    public ShowdownActionResponse choose(ActiveBattlePokemon pkmn, PokemonBattle battle, BattleSide aiSide, ShowdownMoveset moveset, boolean forceSwitch) {
        Object var7_6;
        Debug.log(1, () -> ModCommon.LOG.info(String.format("[REQUEST for %s]: noCancel: %b, wait: %b, must: %b, fitForced: %b, sending: %d, responses: %d, active: %d, forceSwitch: [%s ]", pkmn.getActor().getName().getString(), pkmn.getActor().getRequest().getNoCancel(), pkmn.getActor().getRequest().getWait(), pkmn.getActor().getMustChoose(), pkmn.getActor().canFitForcedAction(), pkmn.getActor().getStillSendingOutCount(), pkmn.getActor().getResponses() != null ? pkmn.getActor().getResponses().size() : 0, pkmn.getActor().getRequest().getActive() != null ? pkmn.getActor().getRequest().getActive().size() : 0, pkmn.getActor().getRequest().getForceSwitch() != null ? pkmn.getActor().getRequest().getForceSwitch().stream().map(String::valueOf).reduce("", (a, b) -> a + " " + b) : "")));
        Debug.log(2, () -> {
            if (pkmn.isAlive()) {
                BattleEffects.dump(pkmn.getBattlePokemon());
                pkmn.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(p -> p.isAlive()).map(p -> p.getBattlePokemon()).forEach(BattleEffects::dump);
            }
        });
        if (pkmn.hasPokemon() && moveset != null && (var7_6 = RCTApi.getInstances().map(rct -> ((RCTApi)rct.getValue()).getTrainerRegistry().getByOT(pkmn.getBattlePokemon().getEffectedPokemon())).filter(t -> t != null && t instanceof TrainerNPC).findFirst().orElse(null)) instanceof TrainerNPC) {
            TrainerNPC trainer = var7_6;
            BattleStates.BattleState battleState = BattleStates.get(pkmn.getBattle());
            BattleStates.ActorState actorState = battleState.getActorState(pkmn.getActor());
            BattleStates.PokemonState pkmnState = battleState.getPokemonState(pkmn.getBattlePokemon());
            Gimmicks gimmicks = trainer.getGimmicks().of(pkmn.getBattlePokemon().getOriginalPokemon());
            moveset.setCanDynamax(ModCommon.modLoader().isLoaded("mega_showdown") && gimmicks.dynamax() && !actorState.hasGimmick(ShowdownMoveset.Gimmick.DYNAMAX.getId()) && !pkmnState.has(BattleEffects.Custom.MEGA) && !pkmnState.has(BattleEffects.Custom.TERA) && !moveset.getCanUltraBurst() && !moveset.getCanMegaEvo() && moveset.getCanZMove() == null);
            moveset.setCanTerastallize(gimmicks.tera() != null && !actorState.hasGimmick(ShowdownMoveset.Gimmick.TERASTALLIZATION.getId()) && !actorState.hasGimmick(ShowdownMoveset.Gimmick.MEGA_EVOLUTION.getId()) && !pkmnState.has(BattleEffects.Custom.MEGA) && !pkmnState.has(BattleEffects.Custom.ZMOVE) && !pkmnState.has(BattleEffects.Custom.DYNAMAX) && !moveset.getCanDynamax() && !moveset.getCanUltraBurst() && !moveset.getCanMegaEvo() && moveset.getCanZMove() == null ? gimmicks.tera() : null);
            if (!moveset.getCanDynamax()) {
                moveset.setMaxMoves(null);
            }
        }
        ResponseBuilder builder = ResponseBuilder.create(pkmn, moveset, forceSwitch).margin(this.rng.nextDouble(this.maxSelectMargin)).random(this.rng);
        builder.suggestMoves(candidates -> candidates.filter(pair -> {
            ActiveBattlePokemon targetPkmn;
            Object patt0$temp = pair.second;
            return !(patt0$temp instanceof ActiveBattlePokemon) || (targetPkmn = (ActiveBattlePokemon)patt0$temp).isAlive();
        }).map(pair -> {
            Object patt0$temp = pair.second;
            if (patt0$temp instanceof ActiveBattlePokemon) {
                ActiveBattlePokemon targetPkmn = (ActiveBattlePokemon)patt0$temp;
                return new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("MOVE %s -> %s", ((InBattleMove)pair.first).id, targetPkmn.getBattlePokemon().getName().getString()), (ResponseBuilder.Pair)pair, 1.0 - this.evalMove(pkmn.getBattlePokemon(), targetPkmn.getBattlePokemon(), (InBattleMove)pair.first));
            }
            return new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("MOVE %s -> <multi/none>", ((InBattleMove)pair.first).id), (ResponseBuilder.Pair)pair, 1.0 - this.evalMove(pkmn.getBattlePokemon(), null, (InBattleMove)pair.first));
        }));
        builder.suggestItems(candidates -> candidates.map(pair -> new ResponseBuilder.Choice<ResponseBuilder.Pair>(String.format("ITEM %s -> %s", ((BagItem)pair.first).getItemName(), ((BattlePokemon)pair.second).getName().getString()), (ResponseBuilder.Pair)pair, 1.0 - this.evalItem((BagItem)pair.first, (BattlePokemon)pair.second))));
        if (forceSwitch || !pkmn.hasPokemon() || !BattleEffects.Pokemon.State.trapped(pkmn.getBattlePokemon())) {
            builder.suggestSwitches(candidates -> candidates.map(bp -> new ResponseBuilder.Choice<BattlePokemon>(String.format("SWITCH %s -> %s", pkmn.isAlive() ? pkmn.getBattlePokemon().getName().getString() : "<dead>", bp.getName().getString()), (BattlePokemon)bp, 1.0 - this.evalSwitch(pkmn, (BattlePokemon)bp))));
        }
        return builder.response();
    }

    private double evalMove(BattlePokemon from, BattlePokemon to, InBattleMove move) {
        double e;
        MoveType mt = MoveType.of(move);
        if (to == null) {
            List all = mt == MoveType.HEAL || mt == MoveType.CURE || mt == MoveType.BUFF ? from.getActor().getSide().getActivePokemon() : from.getActor().getSide().getOppositeSide().getActivePokemon();
            return all.stream().filter(ActiveBattlePokemon::hasPokemon).map(pkmn -> this.evalMove(from, pkmn.getBattlePokemon(), move)).max(Double::compare).orElse(0.0);
        }
        boolean ally = from.actor.getSide().equals(to.actor.getSide());
        switch (mt) {
            case HEAL: {
                e = ally ? java.lang.Math.max(this.rngSin() * this.maxSelectMargin, 1.0 - (double)to.getHealth() / (double)to.getMaxHealth()) * this.statusMoveBias : 0.0;
                break;
            }
            case CURE: {
                e = ally ? (BattleEffects.Pokemon.Status.any(to) ? this.rngSin() : this.rngSin() * this.maxSelectMargin) * this.statusMoveBias : 0.0;
                break;
            }
            case BUFF: {
                e = ally ? (1.0 - this.rngSin()) * java.lang.Math.min(1.0, java.lang.Math.max(0.0, this.rngSin() - BattleEffects.Pokemon.Boost.avg(to) * 5.0)) * this.statusMoveBias : 0.0;
                double h = (double)from.getHealth() / (double)from.getMaxHealth();
                e *= h * h;
                break;
            }
            case MALUS: {
                e = !ally ? (1.0 - this.rngSin()) * java.lang.Math.min(1.0, java.lang.Math.max(0.0, this.rngSin() + BattleEffects.Pokemon.Boost.avg(to) * 5.0)) * this.statusMoveBias : 0.0;
                double h = (double)to.getHealth() / (double)to.getMaxHealth();
                e *= h * h;
                break;
            }
            case STATUS: {
                e = !ally ? (!BattleEffects.Pokemon.Status.any(to) && !BattleEffects.Pokemon.Volatile.any(to) ? 1.0 - this.rngSin() : this.rngSin() * this.maxSelectMargin) * this.statusMoveBias : 0.0;
                int used = BattleStates.get(from.getActor().getBattle()).getPokemonState(from).age(BattleEffects.Custom.USED_STATUS);
                int targets = ally ? from.getActor().getActivePokemon().size() : to.getActor().getActivePokemon().size();
                double r = 1.0 - java.lang.Math.min(1.0, (double)used / (double)targets) * this.rngSin();
                e *= r;
                break;
            }
            case DAMAGE: {
                double dmg = (double)java.lang.Math.min(to.getHealth(), PokeMath.damage(from, to, move)) / (double)to.getHealth();
                e = !ally ? java.lang.Math.min(1.0, dmg + (1.0 - this.rngSin()) * this.maxSelectMargin) * this.moveBias : 0.0;
                break;
            }
            default: {
                e = this.rng.nextDouble();
            }
        }
        Pokemon fromEP = BattleStates.getTransformationOrEffected(from);
        Pokemon toEp = BattleStates.getTransformationOrEffected(to);
        double health = (double)from.getHealth() / (double)from.getMaxHealth();
        MoveTemplate mvtmp = Moves.getByName((String)move.id);
        boolean faster = ally || fromEP.getSpeed() >= toEp.getSpeed() || mvtmp != null && mvtmp.getPriority() > 0;
        double speedFactor = faster ? 1.0 : this.rngRange(health, 1.0, true);
        return e == 0.0 ? -1.0 : MoveType.eval(from, to, move.id) * MoveType.eval(from, to, mt) * speedFactor * e;
    }

    private double evalItem(BagItem item, BattlePokemon to) {
        if (item instanceof PotionType) {
            PotionType potion = (PotionType)item;
            int amount = potion == PotionType.POTION ? java.lang.Math.min(20, to.getMaxHealth()) : (potion == PotionType.SUPER_POTION ? java.lang.Math.min(50, to.getMaxHealth()) : (potion == PotionType.HYPER_POTION ? java.lang.Math.min(200, to.getMaxHealth()) : (potion == PotionType.MAX_POTION ? to.getMaxHealth() : (potion == PotionType.FULL_RESTORE ? to.getMaxHealth() : 0))));
            double estHeal = (double)(java.lang.Math.min(to.getMaxHealth(), to.getHealth() + amount) - to.getHealth()) / (double)amount;
            return java.lang.Math.min(1.0, (double)amount / (double)to.getMaxHealth() * (1.0 - (double)to.getHealth() / (double)to.getMaxHealth()) * java.lang.Math.min(1.0, estHeal * (to.isSentOut() ? 1.0 : 0.75) * (BattleEffects.Pokemon.Status.any(to) && potion.getCuresStatus() ? 1.25 : 1.0)) * this.itemBias);
        }
        return 0.0;
    }

    private double evalSwitch(ActiveBattlePokemon from, BattlePokemon to) {
        WeightedCollection<Double> deltas = new WeightedCollection<Double>();
        double bsd = this.gaussNorm(from.hasPokemon() ? java.lang.Math.max(0.0, java.lang.Math.min(1.0, 0.5 - BattleEffects.Pokemon.Boost.avg(from.getBattlePokemon()))) : 0.0, 0.125);
        deltas.add(bsd, 6);
        double sad = this.gaussNorm(from.hasPokemon() && (BattleEffects.Pokemon.Status.any(from.getBattlePokemon()) || BattleEffects.Pokemon.Volatile.any(from.getBattlePokemon())) ? 0.5 : 0.0, 0.125);
        deltas.add(sad, 8);
        Pokemon fromEP = from.hasPokemon() ? BattleStates.getTransformationOrEffected(from.getBattlePokemon()) : null;
        Pokemon toEP = BattleStates.getTransformationOrEffected(to);
        int atkFrom = fromEP != null ? fromEP.getAttack() : 0;
        int spaFrom = fromEP != null ? fromEP.getSpecialAttack() : 0;
        int defFrom = fromEP != null ? fromEP.getAttack() : 0;
        int spdFrom = fromEP != null ? fromEP.getSpecialAttack() : 0;
        int atkTo = toEP.getAttack();
        int spaTo = toEP.getSpecialAttack();
        int defTo = toEP.getAttack();
        int spdTo = toEP.getSpecialAttack();
        to.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).forEach(pkmn -> {
            double effFromOpp = from.hasPokemon() ? java.lang.Math.min(1.0, TypeChart.getAverageEffectiveness(from.getBattlePokemon(), pkmn.getBattlePokemon()) / 2.0) : 0.0;
            double effOppFrom = from.hasPokemon() ? java.lang.Math.min(1.0, TypeChart.getAverageEffectiveness(pkmn.getBattlePokemon(), from.getBattlePokemon()) / 2.0) : 0.0;
            double effToOpp = java.lang.Math.min(1.0, TypeChart.getAverageEffectiveness(to, pkmn.getBattlePokemon()) / 2.0);
            double effOppTo = java.lang.Math.min(1.0, TypeChart.getAverageEffectiveness(pkmn.getBattlePokemon(), to) / 2.0);
            double effFrom = from.hasPokemon() ? (effFromOpp + (1.0 - effOppFrom)) / 2.0 : 0.0;
            double effTo = (effToOpp + (1.0 - effOppTo)) / 2.0;
            double efd = this.gaussClamp(this.sinPI_2(effTo - effFrom), 0.125, -1.0, 1.0);
            deltas.add(efd, 48);
            Pokemon oppEP = pkmn.hasPokemon() ? BattleStates.getTransformationOrEffected(pkmn.getBattlePokemon()) : null;
            double atkOpp = oppEP != null ? (double)oppEP.getAttack() : 0.0;
            double spaOpp = oppEP != null ? (double)oppEP.getSpecialAttack() : 0.0;
            double defOpp = oppEP != null ? (double)oppEP.getAttack() : 0.0;
            double spdOpp = oppEP != null ? (double)oppEP.getSpecialAttack() : 0.0;
            double atkFromN = defOpp > 0.0 ? java.lang.Math.min(1.0, (double)atkFrom / defOpp) : 1.0;
            double spaFromN = spdOpp > 0.0 ? java.lang.Math.min(1.0, (double)spaFrom / spdOpp) : 1.0;
            double defFromN = atkOpp > 0.0 ? java.lang.Math.min(1.0, (double)defFrom / atkOpp) : 1.0;
            double spdFromN = spaOpp > 0.0 ? java.lang.Math.min(1.0, (double)spdFrom / spaOpp) : 1.0;
            double atkToN = defOpp > 0.0 ? java.lang.Math.min(1.0, (double)atkTo / defOpp) : 1.0;
            double spaToN = spdOpp > 0.0 ? java.lang.Math.min(1.0, (double)spaTo / spdOpp) : 1.0;
            double defToN = atkOpp > 0.0 ? java.lang.Math.min(1.0, (double)defTo / atkOpp) : 1.0;
            double spdToN = spaOpp > 0.0 ? java.lang.Math.min(1.0, (double)spdTo / spaOpp) : 1.0;
            double statsFrom = (atkFromN + spaFromN + defFromN + spdFromN) / 4.0;
            double statsTo = (atkToN + spaToN + defToN + spdToN) / 4.0;
            double std = this.gaussClamp(this.sinPI_2(statsTo - statsFrom), 0.125, -1.0, 1.0);
            deltas.add(std, 12);
            double hld = oppEP != null ? this.gaussNorm(0.33 * (double)pkmn.getBattlePokemon().getHealth() / (double)pkmn.getBattlePokemon().getMaxHealth(), this.maxSelectMargin) : 0.0;
            deltas.add(hld, 6);
            double ldd = oppEP != null ? this.gaussNorm(java.lang.Math.min(1.0, 0.33 * (double)toEP.getLevel() / (double)oppEP.getLevel()), this.maxSelectMargin) : 0.0;
            deltas.add(ldd, 12);
        });
        double fhCur = from.hasPokemon() ? from.getBattlePokemon().getHealth() : 0;
        double fhMax = from.hasPokemon() ? from.getBattlePokemon().getMaxHealth() : 1;
        double fhRel = fhCur / fhMax;
        double thRel = (double)to.getHealth() / (double)to.getMaxHealth();
        deltas.add(this.gaussClamp(thRel - fhRel, 0.125, -1.0, 1.0), 6);
        double agef = !from.hasPokemon() || from.getBattle().getTurn() == 0 || BattleStates.get(from.getBattle()).getPokemonState(from.getBattlePokemon()).age(BattleEffects.Custom.TURN) > 1 ? 1.0 : this.gaussNorm();
        double dmf = from.hasPokemon() && BattleStates.get(from.getBattle()).getPokemonState(from.getBattlePokemon()).has(BattleEffects.Custom.DYNAMAX) ? this.rngRange(java.lang.Math.pow(0.25, 2.0), 0.25) : 1.0;
        double delta = java.lang.Math.max(0.0, deltas.getWeightedSum()) / (double)deltas.getTotalWeight();
        double deltaBiased = this.gaussClamp(delta, this.switchBias / 2.0, delta, 1.0);
        double rating = deltaBiased * agef * dmf;
        rating = this.rngRange(java.lang.Math.pow(rating, 1.25), rating);
        return rating;
    }

    private double sinPI_2(double value) {
        return Math.sin((double)(value * 1.5707963267948966));
    }

    private double rngSin() {
        return this.sinPI_2(this.rng.nextDouble() * 1.5707963267948966);
    }

    private double rngRange(double min, double max) {
        return this.rngRange(min, max, false);
    }

    private double rngRange(double min, double max, boolean optimistic) {
        double range = max - min;
        return min + (optimistic ? this.rngSin() * range : (1.0 - this.rngSin()) * range);
    }

    private double gaussNorm() {
        return this.gaussNorm(0.5);
    }

    private double gaussNorm(double mean) {
        return this.gaussNorm(mean, 1.0);
    }

    private double gaussNorm(double mean, double sig3) {
        return this.gaussClamp(mean, sig3, 0.0, 1.0);
    }

    private double gaussClamp(double mean, double sig3, double min, double max) {
        return java.lang.Math.clamp(this.rng.nextGaussian(mean, sig3 / 3.0), min, max);
    }
}

