/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.unchained.booster;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.timcore.AbstractHandler;
import us.timinc.mc.cobblemon.timcore.PokemonExtensionsKt;
import us.timinc.mc.cobblemon.timcore.PokemonRepresentation;
import us.timinc.mc.cobblemon.unchained.Unchained;
import us.timinc.mc.cobblemon.unchained.booster.AbstractBooster;
import us.timinc.mc.cobblemon.unchained.booster.AbstractBoosterRunner;
import us.timinc.mc.cobblemon.unchained.config.ShinyBoosterConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0006\u0007\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster;", "Lus/timinc/mc/cobblemon/unchained/booster/AbstractBooster;", "<init>", "()V", "", "initialize", "Runner", "ShinyBoosterInfluence", "ShinyEggHandler", "ShinyFossilHandler", "ShinyCaptureHandler", "common"})
public final class ShinyBooster
extends AbstractBooster {
    @NotNull
    public static final ShinyBooster INSTANCE = new ShinyBooster();

    private ShinyBooster() {
    }

    @Override
    public void initialize() {
        Unchained.INSTANCE.registerPlayerSpawnerInfluence(new ShinyBoosterInfluence(Unchained.INSTANCE.getShinySpawnBooster(), null, 2, null));
        Unchained.INSTANCE.registerFishingSpawnerInfluence(new ShinyBoosterInfluence(Unchained.INSTANCE.getShinyFishBooster(), null, 2, null));
        Unchained.INSTANCE.registerSnackSpawnerInfluence(new ShinyBoosterInfluence(Unchained.INSTANCE.getShinySnackBooster(), null, 2, null));
        CobblemonEvents.HATCH_EGG_PRE.subscribe(Priority.LOWEST, (Function1)new Function1<HatchEggEvent.Pre, Unit>((Object)ShinyEggHandler.INSTANCE){

            public final void invoke(HatchEggEvent.Pre p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ShinyEggHandler)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.LOWEST, (Function1)new Function1<FossilRevivedEvent, Unit>((Object)ShinyFossilHandler.INSTANCE){

            public final void invoke(FossilRevivedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ShinyFossilHandler)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOWEST, (Function1)new Function1<PokemonCapturedEvent, Unit>((Object)ShinyCaptureHandler.INSTANCE){

            public final void invoke(PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ShinyCaptureHandler)((Object)this.receiver)).handle(p0);
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$Runner;", "Lus/timinc/mc/cobblemon/unchained/booster/AbstractBoosterRunner;", "Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;", "pokemon", "config", "Lkotlin/Function0;", "", "lockToPlayer", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;Lkotlin/jvm/functions/Function0;)V", "", "roll", "()Z", "test", "boost", "()V", "Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;", "getConfig", "()Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;", "common"})
    @SourceDebugExtension(value={"SMAP\nShinyBooster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShinyBooster.kt\nus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$Runner\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,123:1\n17#2,2:124\n19#2:128\n13805#3,2:126\n*S KotlinDebug\n*F\n+ 1 ShinyBooster.kt\nus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$Runner\n*L\n40#1:124,2\n40#1:128\n40#1:126,2\n*E\n"})
    public static final class Runner
    extends AbstractBoosterRunner<ShinyBoosterConfig> {
        @NotNull
        private final ShinyBoosterConfig config;

        public Runner(@NotNull ServerPlayer player, @NotNull PokemonRepresentation<?> pokemon, @NotNull ShinyBoosterConfig config, @NotNull Function0<Unit> lockToPlayer) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(pokemon, (String)"pokemon");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(lockToPlayer, (String)"lockToPlayer");
            super(player, pokemon, lockToPlayer);
            this.config = config;
        }

        public /* synthetic */ Runner(ServerPlayer serverPlayer, PokemonRepresentation pokemonRepresentation, ShinyBoosterConfig shinyBoosterConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function0 = Runner::_init_$lambda$0;
            }
            this(serverPlayer, pokemonRepresentation, shinyBoosterConfig, (Function0<Unit>)function0);
        }

        @Override
        @NotNull
        public ShinyBoosterConfig getConfig() {
            return this.config;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean roll() {
            float roll;
            void this_$iv;
            float shinyRate = 0.0f;
            shinyRate = Cobblemon.INSTANCE.getConfig().getShinyRate();
            EventObservable eventObservable = CobblemonEvents.SHINY_CHANCE_CALCULATION;
            ShinyChanceCalculationEvent[] shinyChanceCalculationEventArray = new ShinyChanceCalculationEvent[]{new ShinyChanceCalculationEvent(shinyRate, this.getPokemon().getPokemon())};
            ShinyChanceCalculationEvent[] events$iv = shinyChanceCalculationEventArray;
            boolean $i$f$post = false;
            this_$iv.emit((Object[])Arrays.copyOf(events$iv, events$iv.length));
            ShinyChanceCalculationEvent[] $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                ShinyChanceCalculationEvent element$iv$iv;
                ShinyChanceCalculationEvent event = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                shinyRate = event.calculate(this.getPlayer());
            }
            if (shinyRate < 1.0f) {
                shinyRate = 1.0f / shinyRate;
            }
            boolean passedRoll = (roll = Random.Default.nextFloat()) < (1.0f + this.getUnlockedBoost()) / shinyRate;
            AbstractBoosterRunner.debug$default(this, "Calculated shiny rate is " + shinyRate + ". Roll is " + roll + ". Roll " + (passedRoll ? "passed" : "failed") + ".", false, 2, null);
            return passedRoll;
        }

        @Override
        public boolean test() {
            if (this.getPokemon().getShiny()) {
                AbstractBoosterRunner.debug$default(this, "Pokemon's already shiny from something else.", false, 2, null);
                return false;
            }
            return true;
        }

        @Override
        public void boost() {
            this.getPokemon().makeShiny();
            AbstractBoosterRunner.debug$default(this, "Pokemon made shiny.", false, 2, null);
        }

        private static final Unit _init_$lambda$0() {
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\r\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$ShinyBoosterInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;", "config", "Lnet/minecraft/server/level/ServerPlayer;", "player", "<init>", "(Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "Lnet/minecraft/world/entity/Entity;", "entity", "", "affectSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lnet/minecraft/world/entity/Entity;)V", "Lus/timinc/mc/cobblemon/unchained/config/ShinyBoosterConfig;", "Lnet/minecraft/server/level/ServerPlayer;", "common"})
    public static final class ShinyBoosterInfluence
    implements SpawningInfluence {
        @NotNull
        private final ShinyBoosterConfig config;
        @Nullable
        private final ServerPlayer player;

        public ShinyBoosterInfluence(@NotNull ShinyBoosterConfig config, @Nullable ServerPlayer player) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.player = player;
        }

        public /* synthetic */ ShinyBoosterInfluence(ShinyBoosterConfig shinyBoosterConfig, ServerPlayer serverPlayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                serverPlayer = null;
            }
            this(shinyBoosterConfig, serverPlayer);
        }

        public void affectSpawn(@NotNull SpawnAction<?> action, @NotNull Entity entity) {
            Entity entity2;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (!(action instanceof PokemonSpawnAction) || !(entity instanceof PokemonEntity)) {
                return;
            }
            ServerPlayer serverPlayer = this.player;
            if (serverPlayer == null && (serverPlayer = (entity2 = ((PokemonSpawnAction)action).getSpawnablePosition().getCause().getEntity()) instanceof ServerPlayer ? (ServerPlayer)entity2 : null) == null) {
                return;
            }
            ServerPlayer player = serverPlayer;
            PokemonRepresentation.FromEntity pokemonRep = new PokemonRepresentation.FromEntity((PokemonEntity)entity);
            new Runner(player, (PokemonRepresentation)pokemonRep, this.config, (Function0<Unit>)((Function0)() -> ShinyBoosterInfluence.affectSpawn$lambda$0(entity, player))).runThrough();
        }

        private static final Unit affectSpawn$lambda$0(Entity $entity, ServerPlayer $player) {
            PokemonExtensionsKt.reserveFor((Pokemon)((PokemonEntity)$entity).getPokemon(), (ServerPlayer)$player);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$ShinyCaptureHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "common"})
    public static final class ShinyCaptureHandler
    extends AbstractHandler<PokemonCapturedEvent> {
        @NotNull
        public static final ShinyCaptureHandler INSTANCE = new ShinyCaptureHandler();

        private ShinyCaptureHandler() {
        }

        public void handle(@NotNull PokemonCapturedEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            new Runner(evt.getPlayer(), (PokemonRepresentation)new PokemonRepresentation.FromPokemon(evt.getPokemon()), Unchained.INSTANCE.getShinyCaptureBooster(), null, 8, null).runThrough();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$ShinyEggHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Pre;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Pre;)V", "common"})
    public static final class ShinyEggHandler
    extends AbstractHandler<HatchEggEvent.Pre> {
        @NotNull
        public static final ShinyEggHandler INSTANCE = new ShinyEggHandler();

        private ShinyEggHandler() {
        }

        public void handle(@NotNull HatchEggEvent.Pre evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            new Runner(evt.getPlayer(), (PokemonRepresentation)new PokemonRepresentation.FromProperties(evt.getEgg()), Unchained.INSTANCE.getShinyEggBooster(), null, 8, null).runThrough();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/ShinyBooster$ShinyFossilHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;)V", "common"})
    public static final class ShinyFossilHandler
    extends AbstractHandler<FossilRevivedEvent> {
        @NotNull
        public static final ShinyFossilHandler INSTANCE = new ShinyFossilHandler();

        private ShinyFossilHandler() {
        }

        public void handle(@NotNull FossilRevivedEvent evt) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                ServerPlayer serverPlayer = evt.getPlayer();
                if (serverPlayer == null) break block0;
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                new Runner(it, (PokemonRepresentation)new PokemonRepresentation.FromPokemon(evt.getPokemon()), Unchained.INSTANCE.getShinyRezBooster(), null, 8, null).runThrough();
            }
        }
    }
}

