/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.network;

import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.entity.Luggage;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CallLuggagePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<CallLuggagePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"luggage", (String)"call_nearby_luggage"));
    public static final CallLuggagePacket INSTANCE = new CallLuggagePacket();
    public static final StreamCodec<ByteBuf, CallLuggagePacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(IPayloadContext ctx) {
        if (ctx.flow().isServerbound()) {
            ctx.enqueueWork(() -> {
                Player player = ctx.player();
                ServerLevel level = (ServerLevel)player.level();
                level.getAllEntities().forEach(luggageIHope -> {
                    AbstractLuggage luggage;
                    if (luggageIHope instanceof AbstractLuggage && (luggage = (AbstractLuggage)((Object)((Object)luggageIHope))).getOwner() != null && luggage.getOwner().is((Entity)player)) {
                        luggage.stopRiding();
                        luggage.moveTo(player.position());
                        if (luggage instanceof Luggage) {
                            Luggage fetcher = (Luggage)luggage;
                            if (fetcher.isTryingToFetchItem()) {
                                fetcher.setTryingToFetchItem(false);
                            }
                            fetcher.setFetchCooldown(200);
                        }
                        luggage.setInSittingPose(false);
                    }
                });
            });
        }
    }
}

