/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.item;

import com.gizmo.luggage.entity.AbstractLuggage;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AbstractLuggageItem<T extends AbstractLuggage>
extends Item {
    private final Supplier<EntityType<T>> luggage;

    public AbstractLuggageItem(Supplier<EntityType<T>> entity, Item.Properties properties) {
        super(properties);
        this.luggage = entity;
    }

    public Supplier<EntityType<T>> getLuggage() {
        return this.luggage;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult result = AbstractLuggageItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = player.getItemInHand(hand);
        if (result.getType() == HitResult.Type.BLOCK) {
            AbstractLuggage entity;
            Vec3 vec = result.getLocation();
            if (!level.isClientSide() && (entity = (AbstractLuggage)this.luggage.get().create(level)) != null) {
                entity.moveTo(vec);
                entity.tame(player);
                this.onLuggagePlaced(stack, entity);
                level.addFreshEntity((Entity)entity);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onLuggagePlaced(ItemStack stack, T luggage) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            luggage.setCustomName(stack.getHoverName());
        }
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

