/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.entity.ai.LuggagePickupItemGoal;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class Luggage
extends AbstractLuggage
implements ContainerListener {
    private static final EntityDataAccessor<Boolean> EXTENDED = SynchedEntityData.defineId(Luggage.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String EXTENDED_TAG = "Extended";
    private SimpleContainer inventory;
    private int fetchCooldown = 0;
    private boolean tryingToFetchItem;
    private boolean isInventoryOpen;

    public Luggage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.createInventory();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LuggagePickupItemGoal(this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.1, 7.0f, 1.0f){

            public boolean canUse() {
                if (super.canUse()) {
                    List items = Luggage.this.level().getEntitiesOfClass(ItemEntity.class, Luggage.this.getBoundingBox().inflate(8.0), item -> (item.onGround() || item.isInWater()) && Luggage.this.hasLineOfSight((Entity)item) && Luggage.this.getInventory().canAddItem(item.getItem()) && item.getItem().getItem().canFitInsideContainerItems());
                    if (Luggage.this.isInSittingPose() || Luggage.this.isTryingToFetchItem()) {
                        return false;
                    }
                    ArrayList<ItemEntity> revisedItems = new ArrayList<ItemEntity>();
                    if (!items.isEmpty()) {
                        for (ItemEntity item2 : items) {
                            Path toPath = Luggage.this.navigation.createPath((Entity)item2, 1);
                            if (toPath == null || !toPath.canReach()) continue;
                            revisedItems.add(item2);
                        }
                    }
                    return revisedItems.isEmpty();
                }
                return false;
            }
        });
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(EXTENDED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ListTag listtag = new ListTag();
        tag.putBoolean(EXTENDED_TAG, this.hasExtendedInventory());
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            listtag.add((Object)itemstack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)compoundtag));
        }
        tag.put("Items", (Tag)listtag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag listtag = tag.getList("Items", 10);
        this.setExtendedInventory(tag.getBoolean(EXTENDED_TAG));
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= this.inventory.getContainerSize()) continue;
            this.inventory.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compoundtag));
        }
    }

    private void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.hasExtendedInventory() ? 54 : 27);
        if (simplecontainer != null) {
            simplecontainer.removeListener((ContainerListener)this);
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean hasExtendedInventory() {
        return (Boolean)this.getEntityData().get(EXTENDED);
    }

    public void setExtendedInventory(boolean extended) {
        this.getEntityData().set(EXTENDED, (Object)extended);
        this.createInventory();
    }

    public void containerChanged(Container container) {
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    public boolean isTryingToFetchItem() {
        return this.tryingToFetchItem;
    }

    public void setTryingToFetchItem(boolean fetch) {
        this.tryingToFetchItem = fetch;
    }

    public int getFetchCooldown() {
        return this.fetchCooldown;
    }

    public void setFetchCooldown(int cooldown) {
        this.fetchCooldown = cooldown;
    }

    public boolean isInventoryOpen() {
        return this.isInventoryOpen;
    }

    public void setInventoryOpen(boolean open) {
        this.isInventoryOpen = open;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.fetchCooldown > 0) {
            --this.fetchCooldown;
        }
        if (this.isInSittingPose() && this.tickCount % 10 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)this.getEyeHeight() + 0.25, this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getRandom().nextDouble(), 0.0, 0.0);
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && this.getOwner() != player && !player.isShiftKeyDown()) {
            player.displayClientMessage((Component)Component.translatable((String)"entity.luggage.player_doesnt_own").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void thunderHit(ServerLevel level, LightningBolt lightningBolt) {
        if (!this.hasExtendedInventory()) {
            this.setExtendedInventory(true);
        } else {
            super.thunderHit(level, lightningBolt);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED) {
            this.getInventory().removeAllItems().forEach(arg_0 -> ((Luggage)this).spawnAtLocation(arg_0));
            this.spawnAnim();
            this.playSound((SoundEvent)LuggageRegistries.LUGGAGE_KILLED.get(), 8.0f, 1.0f);
        }
        super.remove(reason);
    }

    @Override
    public ItemStack createItem() {
        ItemStack luggageItem = new ItemStack((ItemLike)LuggageRegistries.LUGGAGE_ITEM.get());
        if (this.hasExtendedInventory()) {
            luggageItem.set(LuggageRegistries.EXTENDED, (Object)Unit.INSTANCE);
        }
        if (!this.inventory.isEmpty()) {
            luggageItem.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.inventory.getItems()));
        }
        return luggageItem;
    }

    @Override
    public void onOpenMenu(Player player) {
        this.level().gameEvent((Entity)player, (Holder)GameEvent.CONTAINER_OPEN, player.blockPosition());
        if (this.getSoundCooldown() == 0) {
            this.playSound(SoundEvents.CHEST_OPEN, 0.5f, this.getRandom().nextFloat() * 0.1f + 0.9f);
            this.setSoundCooldown(5);
        }
        if (!this.level().isClientSide()) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.containerMenu != sp.inventoryMenu) {
                sp.closeContainer();
            }
            sp.nextContainerCounter();
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new OpenLuggageScreenPacket(sp.containerCounter, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            sp.containerMenu = new LuggageMenu(sp.containerCounter, sp.getInventory(), (Container)this.inventory, this);
            sp.initMenu(sp.containerMenu);
            this.isInventoryOpen = true;
            NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.containerMenu));
        }
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)LuggageRegistries.LUGGAGE_ITEM.get());
    }
}

